/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.proto.AesCtrHmacStreamingKey;
import com.google.crypto.tink.proto.AesCtrHmacStreamingKeyFormat;
import com.google.crypto.tink.proto.AesCtrHmacStreamingParams;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.HmacParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.streamingaead.StreamingAeadUtil;
import com.google.crypto.tink.subtle.AesCtrHmacStreaming;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class AesCtrHmacStreamingKeyManager
extends KeyManagerBase<StreamingAead, AesCtrHmacStreamingKey, AesCtrHmacStreamingKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesCtrHmacStreamingKey";
    private static final int MIN_TAG_SIZE_IN_BYTES = 10;

    public AesCtrHmacStreamingKeyManager() {
        super(StreamingAead.class, AesCtrHmacStreamingKey.class, AesCtrHmacStreamingKeyFormat.class, TYPE_URL);
    }

    @Override
    public StreamingAead getPrimitiveFromKey(AesCtrHmacStreamingKey keyProto) throws GeneralSecurityException {
        return new AesCtrHmacStreaming(keyProto.getKeyValue().toByteArray(), StreamingAeadUtil.toHmacAlgo(keyProto.getParams().getHkdfHashType()), keyProto.getParams().getDerivedKeySize(), StreamingAeadUtil.toHmacAlgo(keyProto.getParams().getHmacParams().getHash()), keyProto.getParams().getHmacParams().getTagSize(), keyProto.getParams().getCiphertextSegmentSize(), 0);
    }

    @Override
    public AesCtrHmacStreamingKey newKeyFromFormat(AesCtrHmacStreamingKeyFormat format) throws GeneralSecurityException {
        return (AesCtrHmacStreamingKey)AesCtrHmacStreamingKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected AesCtrHmacStreamingKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCtrHmacStreamingKey.parseFrom(byteString);
    }

    @Override
    protected AesCtrHmacStreamingKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCtrHmacStreamingKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(AesCtrHmacStreamingKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        if (key.getKeyValue().size() < 16) {
            throw new GeneralSecurityException("key_value must have at least 16 bytes");
        }
        if (key.getKeyValue().size() < key.getParams().getDerivedKeySize()) {
            throw new GeneralSecurityException("key_value must have at least as many bits as derived keys");
        }
        this.validate(key.getParams());
    }

    @Override
    protected void validateKeyFormat(AesCtrHmacStreamingKeyFormat format) throws GeneralSecurityException {
        if (format.getKeySize() < 16) {
            throw new GeneralSecurityException("key_size must be at least 16 bytes");
        }
        this.validate(format.getParams());
    }

    private void validate(AesCtrHmacStreamingParams params) throws GeneralSecurityException {
        Validators.validateAesKeySize(params.getDerivedKeySize());
        if (params.getHkdfHashType() == HashType.UNKNOWN_HASH) {
            throw new GeneralSecurityException("unknown HKDF hash type");
        }
        if (params.getHmacParams().getHash() == HashType.UNKNOWN_HASH) {
            throw new GeneralSecurityException("unknown HMAC hash type");
        }
        this.validateHmacParams(params.getHmacParams());
        if (params.getCiphertextSegmentSize() < params.getDerivedKeySize() + params.getHmacParams().getTagSize() + 8) {
            throw new GeneralSecurityException("ciphertext_segment_size must be at least (derived_key_size + tag_size + 8)");
        }
    }

    private void validateHmacParams(HmacParams params) throws GeneralSecurityException {
        if (params.getTagSize() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (params.getHash()) {
            case SHA1: {
                if (params.getTagSize() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA256: {
                if (params.getTagSize() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA512: {
                if (params.getTagSize() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }
}

