/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.proto.EcdsaKeyFormat;
import com.google.crypto.tink.proto.EcdsaParams;
import com.google.crypto.tink.proto.EcdsaSignatureEncoding;
import com.google.crypto.tink.proto.EllipticCurveType;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.proto.RsaSsaPkcs1KeyFormat;
import com.google.crypto.tink.proto.RsaSsaPkcs1Params;
import com.google.crypto.tink.proto.RsaSsaPssKeyFormat;
import com.google.crypto.tink.proto.RsaSsaPssParams;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.security.spec.RSAKeyGenParameterSpec;

public final class SignatureKeyTemplates {
    public static final KeyTemplate ECDSA_P256 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA256, EllipticCurveType.NIST_P256, EcdsaSignatureEncoding.DER);
    public static final KeyTemplate ECDSA_P384 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA512, EllipticCurveType.NIST_P384, EcdsaSignatureEncoding.DER);
    public static final KeyTemplate ECDSA_P521 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA512, EllipticCurveType.NIST_P521, EcdsaSignatureEncoding.DER);
    public static final KeyTemplate ECDSA_P256_IEEE_P1363 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA256, EllipticCurveType.NIST_P256, EcdsaSignatureEncoding.IEEE_P1363);
    public static final KeyTemplate ECDSA_P384_IEEE_P1363 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA512, EllipticCurveType.NIST_P384, EcdsaSignatureEncoding.IEEE_P1363);
    public static final KeyTemplate ECDSA_P521_IEEE_P1363 = SignatureKeyTemplates.createEcdsaKeyTemplate(HashType.SHA512, EllipticCurveType.NIST_P521, EcdsaSignatureEncoding.IEEE_P1363);
    public static final KeyTemplate ED25519 = (KeyTemplate)KeyTemplate.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.Ed25519PrivateKey").setOutputPrefixType(OutputPrefixType.TINK).build();
    public static final KeyTemplate RSA_SSA_PKCS1_3072_SHA256_F4 = SignatureKeyTemplates.createRsaSsaPkcs1KeyTemplate(HashType.SHA256, 3072, RSAKeyGenParameterSpec.F4);
    public static final KeyTemplate RSA_SSA_PKCS1_4096_SHA512_F4 = SignatureKeyTemplates.createRsaSsaPkcs1KeyTemplate(HashType.SHA512, 4096, RSAKeyGenParameterSpec.F4);
    public static final KeyTemplate RSA_SSA_PSS_3072_SHA256_SHA256_32_F4 = SignatureKeyTemplates.createRsaSsaPssKeyTemplate(HashType.SHA256, HashType.SHA256, 32, 3072, RSAKeyGenParameterSpec.F4);
    public static final KeyTemplate RSA_SSA_PSS_4096_SHA512_SHA512_64_F4 = SignatureKeyTemplates.createRsaSsaPssKeyTemplate(HashType.SHA512, HashType.SHA512, 64, 4096, RSAKeyGenParameterSpec.F4);

    public static KeyTemplate createEcdsaKeyTemplate(HashType hashType, EllipticCurveType curve, EcdsaSignatureEncoding encoding) {
        EcdsaParams params = (EcdsaParams)EcdsaParams.newBuilder().setHashType(hashType).setCurve(curve).setEncoding(encoding).build();
        EcdsaKeyFormat format = (EcdsaKeyFormat)EcdsaKeyFormat.newBuilder().setParams(params).build();
        return (KeyTemplate)KeyTemplate.newBuilder().setValue(format.toByteString()).setTypeUrl("type.googleapis.com/google.crypto.tink.EcdsaPrivateKey").setOutputPrefixType(OutputPrefixType.TINK).build();
    }

    public static KeyTemplate createRsaSsaPkcs1KeyTemplate(HashType hashType, int modulusSize, BigInteger publicExponent) {
        RsaSsaPkcs1Params params = (RsaSsaPkcs1Params)RsaSsaPkcs1Params.newBuilder().setHashType(hashType).build();
        RsaSsaPkcs1KeyFormat format = (RsaSsaPkcs1KeyFormat)RsaSsaPkcs1KeyFormat.newBuilder().setParams(params).setModulusSizeInBits(modulusSize).setPublicExponent(ByteString.copyFrom((byte[])publicExponent.toByteArray())).build();
        return (KeyTemplate)KeyTemplate.newBuilder().setValue(format.toByteString()).setTypeUrl("type.googleapis.com/google.crypto.tink.RsaSsaPkcs1PrivateKey").setOutputPrefixType(OutputPrefixType.TINK).build();
    }

    public static KeyTemplate createRsaSsaPssKeyTemplate(HashType sigHash, HashType mgf1Hash, int saltLength, int modulusSize, BigInteger publicExponent) {
        RsaSsaPssParams params = (RsaSsaPssParams)RsaSsaPssParams.newBuilder().setSigHash(sigHash).setMgf1Hash(mgf1Hash).setSaltLength(saltLength).build();
        RsaSsaPssKeyFormat format = (RsaSsaPssKeyFormat)RsaSsaPssKeyFormat.newBuilder().setParams(params).setModulusSizeInBits(modulusSize).setPublicExponent(ByteString.copyFrom((byte[])publicExponent.toByteArray())).build();
        return (KeyTemplate)KeyTemplate.newBuilder().setValue(format.toByteString()).setTypeUrl("type.googleapis.com/google.crypto.tink.RsaSsaPssPrivateKey").setOutputPrefixType(OutputPrefixType.TINK).build();
    }
}

