/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.RsaSsaPssKeyFormat;
import com.google.crypto.tink.proto.RsaSsaPssParams;
import com.google.crypto.tink.proto.RsaSsaPssPrivateKey;
import com.google.crypto.tink.proto.RsaSsaPssPublicKey;
import com.google.crypto.tink.signature.SigUtil;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.RsaSsaPssSignJce;
import com.google.crypto.tink.subtle.RsaSsaPssVerifyJce;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;

class RsaSsaPssSignKeyManager
extends KeyManagerBase<PublicKeySign, RsaSsaPssPrivateKey, RsaSsaPssKeyFormat>
implements PrivateKeyManager<PublicKeySign> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.RsaSsaPssPrivateKey";
    private static final int VERSION = 0;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] TEST_MESSAGE = "Tink and Wycheproof.".getBytes(UTF_8);

    public RsaSsaPssSignKeyManager() {
        super(PublicKeySign.class, RsaSsaPssPrivateKey.class, RsaSsaPssKeyFormat.class, TYPE_URL);
    }

    @Override
    public PublicKeySign getPrimitiveFromKey(RsaSsaPssPrivateKey keyProto) throws GeneralSecurityException {
        KeyFactory kf = EngineFactory.KEY_FACTORY.getInstance("RSA");
        RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)kf.generatePrivate(new RSAPrivateCrtKeySpec(new BigInteger(1, keyProto.getPublicKey().getN().toByteArray()), new BigInteger(1, keyProto.getPublicKey().getE().toByteArray()), new BigInteger(1, keyProto.getD().toByteArray()), new BigInteger(1, keyProto.getP().toByteArray()), new BigInteger(1, keyProto.getQ().toByteArray()), new BigInteger(1, keyProto.getDp().toByteArray()), new BigInteger(1, keyProto.getDq().toByteArray()), new BigInteger(1, keyProto.getCrt().toByteArray())));
        RsaSsaPssParams params = keyProto.getPublicKey().getParams();
        RsaSsaPssSignJce signer = new RsaSsaPssSignJce(privateKey, SigUtil.toHashType(params.getSigHash()), SigUtil.toHashType(params.getMgf1Hash()), params.getSaltLength());
        RSAPublicKey publicKey = (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(new BigInteger(1, keyProto.getPublicKey().getN().toByteArray()), new BigInteger(1, keyProto.getPublicKey().getE().toByteArray())));
        RsaSsaPssVerifyJce verifier = new RsaSsaPssVerifyJce(publicKey, SigUtil.toHashType(params.getSigHash()), SigUtil.toHashType(params.getMgf1Hash()), params.getSaltLength());
        try {
            verifier.verify(signer.sign(TEST_MESSAGE), TEST_MESSAGE);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Security bug: signing with private key followed by verifying with public key failed" + e);
        }
        return signer;
    }

    @Override
    protected RsaSsaPssPrivateKey newKeyFromFormat(RsaSsaPssKeyFormat format) throws GeneralSecurityException {
        RsaSsaPssParams params = format.getParams();
        Validators.validateRsaModulusSize(format.getModulusSizeInBits());
        Validators.validateSignatureHash(SigUtil.toHashType(params.getSigHash()));
        KeyPairGenerator keyGen = EngineFactory.KEY_PAIR_GENERATOR.getInstance("RSA");
        RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(format.getModulusSizeInBits(), new BigInteger(1, format.getPublicExponent().toByteArray()));
        keyGen.initialize(spec);
        KeyPair keyPair = keyGen.generateKeyPair();
        RSAPublicKey pubKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateCrtKey privKey = (RSAPrivateCrtKey)keyPair.getPrivate();
        RsaSsaPssPublicKey pssPubKey = (RsaSsaPssPublicKey)RsaSsaPssPublicKey.newBuilder().setVersion(0).setParams(params).setE(ByteString.copyFrom((byte[])pubKey.getPublicExponent().toByteArray())).setN(ByteString.copyFrom((byte[])pubKey.getModulus().toByteArray())).build();
        return (RsaSsaPssPrivateKey)RsaSsaPssPrivateKey.newBuilder().setVersion(0).setPublicKey(pssPubKey).setD(ByteString.copyFrom((byte[])privKey.getPrivateExponent().toByteArray())).setP(ByteString.copyFrom((byte[])privKey.getPrimeP().toByteArray())).setQ(ByteString.copyFrom((byte[])privKey.getPrimeQ().toByteArray())).setDp(ByteString.copyFrom((byte[])privKey.getPrimeExponentP().toByteArray())).setDq(ByteString.copyFrom((byte[])privKey.getPrimeExponentQ().toByteArray())).setCrt(ByteString.copyFrom((byte[])privKey.getCrtCoefficient().toByteArray())).build();
    }

    @Override
    public KeyData getPublicKeyData(ByteString serializedKey) throws GeneralSecurityException {
        try {
            RsaSsaPssPrivateKey privKeyProto = RsaSsaPssPrivateKey.parseFrom(serializedKey);
            return (KeyData)KeyData.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.RsaSsaPssPublicKey").setValue(privKeyProto.getPublicKey().toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized RsaSsaPssPrivateKey proto", e);
        }
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
    }

    @Override
    protected RsaSsaPssPrivateKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return RsaSsaPssPrivateKey.parseFrom(byteString);
    }

    @Override
    protected RsaSsaPssKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return RsaSsaPssKeyFormat.parseFrom(byteString);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected void validateKeyFormat(RsaSsaPssKeyFormat format) throws GeneralSecurityException {
        SigUtil.validateRsaSsaPssParams(format.getParams());
        Validators.validateRsaModulusSize(format.getModulusSizeInBits());
    }

    @Override
    protected void validateKey(RsaSsaPssPrivateKey privKey) throws GeneralSecurityException {
        Validators.validateVersion(privKey.getVersion(), 0);
        Validators.validateRsaModulusSize(new BigInteger(1, privKey.getPublicKey().getN().toByteArray()).bitLength());
        SigUtil.validateRsaSsaPssParams(privKey.getPublicKey().getParams());
    }
}

