/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.signature.EcdsaSignKeyManager;
import com.google.crypto.tink.signature.Ed25519PrivateKeyManager;
import com.google.crypto.tink.signature.PublicKeySignWrapper;
import com.google.crypto.tink.signature.RsaSsaPkcs1SignKeyManager;
import com.google.crypto.tink.signature.RsaSsaPssSignKeyManager;
import java.security.GeneralSecurityException;

class PublicKeySignCatalogue
implements Catalogue<PublicKeySign> {
    @Override
    public KeyManager<PublicKeySign> getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<PublicKeySign> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "publickeysign": {
                keyManager = this.publicKeySignKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<PublicKeySign> publicKeySignKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.EcdsaPrivateKey": {
                return new EcdsaSignKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.Ed25519PrivateKey": {
                return new Ed25519PrivateKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.RsaSsaPkcs1PrivateKey": {
                return new RsaSsaPkcs1SignKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.RsaSsaPssPrivateKey": {
                return new RsaSsaPssSignKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'PublicKeySign' with key type '%s'.", typeUrl));
    }

    @Override
    public PrimitiveWrapper<PublicKeySign> getPrimitiveWrapper() {
        return new PublicKeySignWrapper();
    }
}

