/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.proto.Ed25519PublicKey;
import com.google.crypto.tink.proto.Empty;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.Ed25519Verify;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class Ed25519PublicKeyManager
extends KeyManagerBase<PublicKeyVerify, Ed25519PublicKey, Empty> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.Ed25519PublicKey";
    private static final int VERSION = 0;

    public Ed25519PublicKeyManager() {
        super(PublicKeyVerify.class, Ed25519PublicKey.class, Empty.class, TYPE_URL);
    }

    @Override
    public PublicKeyVerify getPrimitiveFromKey(Ed25519PublicKey keyProto) throws GeneralSecurityException {
        return new Ed25519Verify(keyProto.getKeyValue().toByteArray());
    }

    @Override
    protected Ed25519PublicKey newKeyFromFormat(Empty unused) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
    }

    @Override
    protected Ed25519PublicKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Ed25519PublicKey.parseFrom(byteString);
    }

    @Override
    protected Empty parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Empty.parseFrom(byteString);
    }

    @Override
    protected void validateKey(Ed25519PublicKey keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid Ed25519 public key: incorrect key length");
        }
    }

    @Override
    protected void validateKeyFormat(Empty unused) throws GeneralSecurityException {
    }
}

