/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.proto.Ed25519PrivateKey;
import com.google.crypto.tink.proto.Ed25519PublicKey;
import com.google.crypto.tink.proto.Empty;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.Ed25519Sign;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class Ed25519PrivateKeyManager
extends KeyManagerBase<PublicKeySign, Ed25519PrivateKey, Empty>
implements PrivateKeyManager<PublicKeySign> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.Ed25519PrivateKey";
    private static final int VERSION = 0;

    public Ed25519PrivateKeyManager() {
        super(PublicKeySign.class, Ed25519PrivateKey.class, Empty.class, TYPE_URL);
    }

    @Override
    public PublicKeySign getPrimitiveFromKey(Ed25519PrivateKey keyProto) throws GeneralSecurityException {
        return new Ed25519Sign(keyProto.getKeyValue().toByteArray());
    }

    @Override
    public Ed25519PrivateKey newKeyFromFormat(Empty unused) throws GeneralSecurityException {
        Ed25519Sign.KeyPair keyPair = Ed25519Sign.KeyPair.newKeyPair();
        Ed25519PublicKey publicKey = (Ed25519PublicKey)Ed25519PublicKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPublicKey())).build();
        return (Ed25519PrivateKey)Ed25519PrivateKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPrivateKey())).setPublicKey(publicKey).build();
    }

    @Override
    public KeyData getPublicKeyData(ByteString serializedKey) throws GeneralSecurityException {
        try {
            Ed25519PrivateKey privKeyProto = Ed25519PrivateKey.parseFrom(serializedKey);
            return (KeyData)KeyData.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.Ed25519PublicKey").setValue(privKeyProto.getPublicKey().toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized Ed25519PrivateKey proto", e);
        }
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
    }

    @Override
    protected Ed25519PrivateKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Ed25519PrivateKey.parseFrom(byteString);
    }

    @Override
    protected Empty parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Empty.parseFrom(byteString);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected void validateKey(Ed25519PrivateKey keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid Ed25519 private key: incorrect key length");
        }
    }

    @Override
    protected void validateKeyFormat(Empty unused) {
    }
}

