/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.proto.EcdsaPublicKey;
import com.google.crypto.tink.proto.Empty;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.signature.SigUtil;
import com.google.crypto.tink.subtle.EcdsaVerifyJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;

class EcdsaVerifyKeyManager
extends KeyManagerBase<PublicKeyVerify, EcdsaPublicKey, Empty> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.EcdsaPublicKey";
    protected static final int VERSION = 0;

    public EcdsaVerifyKeyManager() {
        super(PublicKeyVerify.class, EcdsaPublicKey.class, Empty.class, TYPE_URL);
    }

    @Override
    public PublicKeyVerify getPrimitiveFromKey(EcdsaPublicKey keyProto) throws GeneralSecurityException {
        ECPublicKey publicKey = EllipticCurves.getEcPublicKey(SigUtil.toCurveType(keyProto.getParams().getCurve()), keyProto.getX().toByteArray(), keyProto.getY().toByteArray());
        return new EcdsaVerifyJce(publicKey, SigUtil.toHashType(keyProto.getParams().getHashType()), SigUtil.toEcdsaEncoding(keyProto.getParams().getEncoding()));
    }

    @Override
    public EcdsaPublicKey newKeyFromFormat(Empty unused) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
    }

    @Override
    protected EcdsaPublicKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return EcdsaPublicKey.parseFrom(byteString);
    }

    @Override
    protected Empty parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Empty.parseFrom(byteString);
    }

    @Override
    protected void validateKey(EcdsaPublicKey pubKey) throws GeneralSecurityException {
        Validators.validateVersion(pubKey.getVersion(), 0);
        SigUtil.validateEcdsaParams(pubKey.getParams());
    }

    @Override
    protected void validateKeyFormat(Empty unused) throws GeneralSecurityException {
    }
}

