/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.proto.EcdsaKeyFormat;
import com.google.crypto.tink.proto.EcdsaParams;
import com.google.crypto.tink.proto.EcdsaPrivateKey;
import com.google.crypto.tink.proto.EcdsaPublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.signature.SigUtil;
import com.google.crypto.tink.subtle.EcdsaSignJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

class EcdsaSignKeyManager
extends KeyManagerBase<PublicKeySign, EcdsaPrivateKey, EcdsaKeyFormat>
implements PrivateKeyManager<PublicKeySign> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.EcdsaPrivateKey";
    private static final int VERSION = 0;

    public EcdsaSignKeyManager() {
        super(PublicKeySign.class, EcdsaPrivateKey.class, EcdsaKeyFormat.class, TYPE_URL);
    }

    @Override
    public PublicKeySign getPrimitiveFromKey(EcdsaPrivateKey keyProto) throws GeneralSecurityException {
        ECPrivateKey privateKey = EllipticCurves.getEcPrivateKey(SigUtil.toCurveType(keyProto.getPublicKey().getParams().getCurve()), keyProto.getKeyValue().toByteArray());
        return new EcdsaSignJce(privateKey, SigUtil.toHashType(keyProto.getPublicKey().getParams().getHashType()), SigUtil.toEcdsaEncoding(keyProto.getPublicKey().getParams().getEncoding()));
    }

    @Override
    public EcdsaPrivateKey newKeyFromFormat(EcdsaKeyFormat format) throws GeneralSecurityException {
        EcdsaParams ecdsaParams = format.getParams();
        KeyPair keyPair = EllipticCurves.generateKeyPair(SigUtil.toCurveType(ecdsaParams.getCurve()));
        ECPublicKey pubKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey privKey = (ECPrivateKey)keyPair.getPrivate();
        ECPoint w = pubKey.getW();
        EcdsaPublicKey ecdsaPubKey = (EcdsaPublicKey)EcdsaPublicKey.newBuilder().setVersion(0).setParams(ecdsaParams).setX(ByteString.copyFrom((byte[])w.getAffineX().toByteArray())).setY(ByteString.copyFrom((byte[])w.getAffineY().toByteArray())).build();
        return (EcdsaPrivateKey)EcdsaPrivateKey.newBuilder().setVersion(0).setPublicKey(ecdsaPubKey).setKeyValue(ByteString.copyFrom((byte[])privKey.getS().toByteArray())).build();
    }

    @Override
    public KeyData getPublicKeyData(ByteString serializedKey) throws GeneralSecurityException {
        try {
            EcdsaPrivateKey privKeyProto = EcdsaPrivateKey.parseFrom(serializedKey);
            return (KeyData)KeyData.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.EcdsaPublicKey").setValue(privKeyProto.getPublicKey().toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized EcdsaPrivateKey proto", e);
        }
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
    }

    @Override
    protected EcdsaPrivateKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return EcdsaPrivateKey.parseFrom(byteString);
    }

    @Override
    protected EcdsaKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return EcdsaKeyFormat.parseFrom(byteString);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected void validateKey(EcdsaPrivateKey privKey) throws GeneralSecurityException {
        Validators.validateVersion(privKey.getVersion(), 0);
        SigUtil.validateEcdsaParams(privKey.getPublicKey().getParams());
    }

    @Override
    protected void validateKeyFormat(EcdsaKeyFormat format) throws GeneralSecurityException {
        SigUtil.validateEcdsaParams(format.getParams());
    }
}

