/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.HmacKey;
import com.google.crypto.tink.proto.HmacKeyFormat;
import com.google.crypto.tink.proto.HmacParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.MacJce;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

class HmacKeyManager
extends KeyManagerBase<Mac, HmacKey, HmacKeyFormat> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.HmacKey";
    private static final int VERSION = 0;
    private static final int MIN_KEY_SIZE_IN_BYTES = 16;
    private static final int MIN_TAG_SIZE_IN_BYTES = 10;

    public HmacKeyManager() {
        super(Mac.class, HmacKey.class, HmacKeyFormat.class, TYPE_URL);
    }

    @Override
    public Mac getPrimitiveFromKey(HmacKey keyProto) throws GeneralSecurityException {
        HashType hash = keyProto.getParams().getHash();
        byte[] keyValue = keyProto.getKeyValue().toByteArray();
        SecretKeySpec keySpec = new SecretKeySpec(keyValue, "HMAC");
        int tagSize = keyProto.getParams().getTagSize();
        switch (hash) {
            case SHA1: {
                return new MacJce("HMACSHA1", keySpec, tagSize);
            }
            case SHA256: {
                return new MacJce("HMACSHA256", keySpec, tagSize);
            }
            case SHA512: {
                return new MacJce("HMACSHA512", keySpec, tagSize);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public HmacKey newKeyFromFormat(HmacKeyFormat format) throws GeneralSecurityException {
        return (HmacKey)HmacKey.newBuilder().setVersion(0).setParams(format.getParams()).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected HmacKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return HmacKey.parseFrom(byteString);
    }

    @Override
    protected HmacKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return HmacKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(HmacKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        if (key.getKeyValue().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        this.validate(key.getParams());
    }

    @Override
    protected void validateKeyFormat(HmacKeyFormat format) throws GeneralSecurityException {
        if (format.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        this.validate(format.getParams());
    }

    private void validate(HmacParams params) throws GeneralSecurityException {
        if (params.getTagSize() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (params.getHash()) {
            case SHA1: {
                if (params.getTagSize() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA256: {
                if (params.getTagSize() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA512: {
                if (params.getTagSize() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }
}

