/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.AesCtrHmacAeadKey;
import com.google.crypto.tink.proto.AesCtrHmacAeadKeyFormat;
import com.google.crypto.tink.proto.AesCtrKey;
import com.google.crypto.tink.proto.AesGcmKey;
import com.google.crypto.tink.proto.AesGcmKeyFormat;
import com.google.crypto.tink.proto.HmacKey;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.subtle.EciesAeadHkdfDemHelper;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.util.Arrays;

class RegistryEciesAeadHkdfDemHelper
implements EciesAeadHkdfDemHelper {
    private final String demKeyTypeUrl;
    private final int symmetricKeySize;
    private AesGcmKey aesGcmKey;
    private AesCtrHmacAeadKey aesCtrHmacAeadKey;
    private int aesCtrKeySize;

    RegistryEciesAeadHkdfDemHelper(KeyTemplate demTemplate) throws GeneralSecurityException {
        this.demKeyTypeUrl = demTemplate.getTypeUrl();
        if (this.demKeyTypeUrl.equals("type.googleapis.com/google.crypto.tink.AesGcmKey")) {
            try {
                AesGcmKeyFormat gcmKeyFormat = AesGcmKeyFormat.parseFrom(demTemplate.getValue());
                this.aesGcmKey = (AesGcmKey)Registry.newKey(demTemplate);
                this.symmetricKeySize = gcmKeyFormat.getKeySize();
            }
            catch (InvalidProtocolBufferException e) {
                throw new GeneralSecurityException("invalid KeyFormat protobuf, expected AesGcmKeyFormat", e);
            }
        } else if (this.demKeyTypeUrl.equals("type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey")) {
            try {
                AesCtrHmacAeadKeyFormat aesCtrHmacAeadKeyFormat = AesCtrHmacAeadKeyFormat.parseFrom(demTemplate.getValue());
                this.aesCtrHmacAeadKey = (AesCtrHmacAeadKey)Registry.newKey(demTemplate);
                this.aesCtrKeySize = aesCtrHmacAeadKeyFormat.getAesCtrKeyFormat().getKeySize();
                int hmacKeySize = aesCtrHmacAeadKeyFormat.getHmacKeyFormat().getKeySize();
                this.symmetricKeySize = this.aesCtrKeySize + hmacKeySize;
            }
            catch (InvalidProtocolBufferException e) {
                throw new GeneralSecurityException("invalid KeyFormat protobuf, expected AesCtrHmacAeadKeyFormat", e);
            }
        } else {
            throw new GeneralSecurityException("unsupported AEAD DEM key type: " + this.demKeyTypeUrl);
        }
    }

    @Override
    public int getSymmetricKeySizeInBytes() {
        return this.symmetricKeySize;
    }

    @Override
    public Aead getAead(byte[] symmetricKeyValue) throws GeneralSecurityException {
        if (symmetricKeyValue.length != this.getSymmetricKeySizeInBytes()) {
            throw new GeneralSecurityException("Symmetric key has incorrect length");
        }
        if (this.demKeyTypeUrl.equals("type.googleapis.com/google.crypto.tink.AesGcmKey")) {
            AesGcmKey aeadKey = (AesGcmKey)((AesGcmKey.Builder)AesGcmKey.newBuilder().mergeFrom(this.aesGcmKey)).setKeyValue(ByteString.copyFrom((byte[])symmetricKeyValue, (int)0, (int)this.symmetricKeySize)).build();
            return Registry.getPrimitive(this.demKeyTypeUrl, (MessageLite)aeadKey, Aead.class);
        }
        if (this.demKeyTypeUrl.equals("type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey")) {
            byte[] aesCtrKeyValue = Arrays.copyOfRange(symmetricKeyValue, 0, this.aesCtrKeySize);
            byte[] hmacKeyValue = Arrays.copyOfRange(symmetricKeyValue, this.aesCtrKeySize, this.symmetricKeySize);
            AesCtrKey aesCtrKey = (AesCtrKey)((AesCtrKey.Builder)AesCtrKey.newBuilder().mergeFrom(this.aesCtrHmacAeadKey.getAesCtrKey())).setKeyValue(ByteString.copyFrom((byte[])aesCtrKeyValue)).build();
            HmacKey hmacKey = (HmacKey)((HmacKey.Builder)HmacKey.newBuilder().mergeFrom(this.aesCtrHmacAeadKey.getHmacKey())).setKeyValue(ByteString.copyFrom((byte[])hmacKeyValue)).build();
            AesCtrHmacAeadKey aeadKey = (AesCtrHmacAeadKey)AesCtrHmacAeadKey.newBuilder().setVersion(this.aesCtrHmacAeadKey.getVersion()).setAesCtrKey(aesCtrKey).setHmacKey(hmacKey).build();
            return Registry.getPrimitive(this.demKeyTypeUrl, (MessageLite)aeadKey, Aead.class);
        }
        throw new GeneralSecurityException("unknown DEM key type");
    }
}

