/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;

class HybridEncryptWrapper
implements PrimitiveWrapper<HybridEncrypt> {
    HybridEncryptWrapper() {
    }

    @Override
    public HybridEncrypt wrap(PrimitiveSet<HybridEncrypt> primitives) {
        return new WrappedHybridEncrypt(primitives);
    }

    @Override
    public Class<HybridEncrypt> getPrimitiveClass() {
        return HybridEncrypt.class;
    }

    private static class WrappedHybridEncrypt
    implements HybridEncrypt {
        final PrimitiveSet<HybridEncrypt> primitives;

        public WrappedHybridEncrypt(PrimitiveSet<HybridEncrypt> primitives) {
            this.primitives = primitives;
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
            return Bytes.concat(this.primitives.getPrimary().getIdentifier(), this.primitives.getPrimary().getPrimitive().encrypt(plaintext, contextInfo));
        }
    }
}

