/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.hybrid.EciesAeadHkdfPublicKeyManager;
import com.google.crypto.tink.hybrid.HybridEncryptWrapper;
import java.security.GeneralSecurityException;

class HybridEncryptCatalogue
implements Catalogue<HybridEncrypt> {
    @Override
    public KeyManager<HybridEncrypt> getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<HybridEncrypt> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "hybridencrypt": {
                keyManager = this.hybridEncryptKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<HybridEncrypt> hybridEncryptKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey": {
                return new EciesAeadHkdfPublicKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'HybridEncrypt' with key type '%s'.", typeUrl));
    }

    @Override
    public PrimitiveWrapper<HybridEncrypt> getPrimitiveWrapper() {
        return new HybridEncryptWrapper();
    }
}

