/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.hybrid.EciesAeadHkdfPrivateKeyManager;
import com.google.crypto.tink.hybrid.HybridDecryptWrapper;
import java.security.GeneralSecurityException;

class HybridDecryptCatalogue
implements Catalogue<HybridDecrypt> {
    @Override
    public KeyManager<HybridDecrypt> getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<HybridDecrypt> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "hybriddecrypt": {
                keyManager = this.hybridDecryptKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<HybridDecrypt> hybridDecryptKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey": {
                return new EciesAeadHkdfPrivateKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'HybridEncrypt' with key type '%s'.", typeUrl));
    }

    @Override
    public PrimitiveWrapper<HybridDecrypt> getPrimitiveWrapper() {
        return new HybridDecryptWrapper();
    }
}

