/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.hybrid.HybridUtil;
import com.google.crypto.tink.hybrid.RegistryEciesAeadHkdfDemHelper;
import com.google.crypto.tink.proto.EciesAeadHkdfParams;
import com.google.crypto.tink.proto.EciesAeadHkdfPublicKey;
import com.google.crypto.tink.proto.EciesHkdfKemParams;
import com.google.crypto.tink.proto.Empty;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.EciesAeadHkdfHybridEncrypt;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;

class EciesAeadHkdfPublicKeyManager
extends KeyManagerBase<HybridEncrypt, EciesAeadHkdfPublicKey, Empty> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey";

    public EciesAeadHkdfPublicKeyManager() {
        super(HybridEncrypt.class, EciesAeadHkdfPublicKey.class, Empty.class, TYPE_URL);
    }

    @Override
    protected HybridEncrypt getPrimitiveFromKey(EciesAeadHkdfPublicKey recipientKeyProto) throws GeneralSecurityException {
        EciesAeadHkdfParams eciesParams = recipientKeyProto.getParams();
        EciesHkdfKemParams kemParams = eciesParams.getKemParams();
        ECPublicKey recipientPublicKey = EllipticCurves.getEcPublicKey(HybridUtil.toCurveType(kemParams.getCurveType()), recipientKeyProto.getX().toByteArray(), recipientKeyProto.getY().toByteArray());
        RegistryEciesAeadHkdfDemHelper demHelper = new RegistryEciesAeadHkdfDemHelper(eciesParams.getDemParams().getAeadDem());
        return new EciesAeadHkdfHybridEncrypt(recipientPublicKey, kemParams.getHkdfSalt().toByteArray(), HybridUtil.toHmacAlgo(kemParams.getHkdfHashType()), HybridUtil.toPointFormatType(eciesParams.getEcPointFormat()), demHelper);
    }

    @Override
    public EciesAeadHkdfPublicKey newKeyFromFormat(Empty format) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented.");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
    }

    @Override
    protected EciesAeadHkdfPublicKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return EciesAeadHkdfPublicKey.parseFrom(byteString);
    }

    @Override
    protected Empty parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Empty.parseFrom(byteString);
    }

    @Override
    protected void validateKey(EciesAeadHkdfPublicKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        HybridUtil.validate(key.getParams());
    }

    @Override
    protected void validateKeyFormat(Empty unused) throws GeneralSecurityException {
    }
}

