/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.daead;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.daead.AesSivKeyManager;
import com.google.crypto.tink.daead.DeterministicAeadWrapper;
import java.security.GeneralSecurityException;

class DeterministicAeadCatalogue
implements Catalogue<DeterministicAead> {
    @Override
    public KeyManager<DeterministicAead> getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<DeterministicAead> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "deterministicaead": {
                keyManager = this.daeadKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<DeterministicAead> daeadKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.AesSivKey": {
                return new AesSivKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'DeterministicAead' with key type '%s'.", typeUrl));
    }

    @Override
    public PrimitiveWrapper<DeterministicAead> getPrimitiveWrapper() {
        return new DeterministicAeadWrapper();
    }
}

