/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.daead;

import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.proto.AesSivKey;
import com.google.crypto.tink.proto.AesSivKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesSiv;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;

class AesSivKeyManager
extends KeyManagerBase<DeterministicAead, AesSivKey, AesSivKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesSivKey";

    public AesSivKeyManager() {
        super(DeterministicAead.class, AesSivKey.class, AesSivKeyFormat.class, TYPE_URL);
    }

    @Override
    protected DeterministicAead getPrimitiveFromKey(AesSivKey keyProto) throws GeneralSecurityException {
        return new AesSiv(keyProto.getKeyValue().toByteArray());
    }

    @Override
    public AesSivKey newKeyFromFormat(AesSivKeyFormat format) throws GeneralSecurityException {
        return (AesSivKey)AesSivKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected AesSivKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesSivKey.parseFrom(byteString);
    }

    @Override
    protected AesSivKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesSivKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(AesSivKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        if (key.getKeyValue().size() != 64) {
            throw new InvalidKeyException("invalid key size: " + key.getKeyValue().size() + ". Valid keys must have 64 bytes.");
        }
    }

    @Override
    protected void validateKeyFormat(AesSivKeyFormat format) throws GeneralSecurityException {
        if (format.getKeySize() != 64) {
            throw new InvalidAlgorithmParameterException("invalid key size: " + format.getKeySize() + ". Valid keys must have 64 bytes.");
        }
    }
}

