/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.proto.Empty;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.XChaCha20Poly1305Key;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.crypto.tink.subtle.XChaCha20Poly1305;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class XChaCha20Poly1305KeyManager
extends KeyManagerBase<Aead, XChaCha20Poly1305Key, Empty> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.XChaCha20Poly1305Key";
    private static final int KEY_SIZE_IN_BYTES = 32;
    private static final int VERSION = 0;

    public XChaCha20Poly1305KeyManager() {
        super(Aead.class, XChaCha20Poly1305Key.class, Empty.class, TYPE_URL);
    }

    @Override
    public Aead getPrimitiveFromKey(XChaCha20Poly1305Key keyProto) throws GeneralSecurityException {
        return new XChaCha20Poly1305(keyProto.getKeyValue().toByteArray());
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected XChaCha20Poly1305Key newKeyFromFormat(Empty unused) throws GeneralSecurityException {
        return (XChaCha20Poly1305Key)XChaCha20Poly1305Key.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(32))).build();
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected XChaCha20Poly1305Key parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return XChaCha20Poly1305Key.parseFrom(byteString);
    }

    @Override
    protected Empty parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Empty.parseFrom(byteString);
    }

    @Override
    protected void validateKey(XChaCha20Poly1305Key keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid XChaCha20Poly1305Key: incorrect key length");
        }
    }

    @Override
    protected void validateKeyFormat(Empty empty) throws GeneralSecurityException {
    }
}

