/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.aead.KmsEnvelopeAead;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKey;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKeyFormat;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class KmsEnvelopeAeadKeyManager
extends KeyManagerBase<Aead, KmsEnvelopeAeadKey, KmsEnvelopeAeadKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsEnvelopeAeadKey";

    public KmsEnvelopeAeadKeyManager() {
        super(Aead.class, KmsEnvelopeAeadKey.class, KmsEnvelopeAeadKeyFormat.class, TYPE_URL);
    }

    @Override
    public Aead getPrimitiveFromKey(KmsEnvelopeAeadKey keyProto) throws GeneralSecurityException {
        String keyUri = keyProto.getParams().getKekUri();
        KmsClient kmsClient = KmsClients.get(keyUri);
        Aead remote = kmsClient.getAead(keyUri);
        return new KmsEnvelopeAead(keyProto.getParams().getDekTemplate(), remote);
    }

    @Override
    public KmsEnvelopeAeadKey newKeyFromFormat(KmsEnvelopeAeadKeyFormat format) throws GeneralSecurityException {
        return (KmsEnvelopeAeadKey)KmsEnvelopeAeadKey.newBuilder().setParams(format).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.REMOTE;
    }

    @Override
    protected KmsEnvelopeAeadKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return KmsEnvelopeAeadKey.parseFrom(byteString);
    }

    @Override
    protected KmsEnvelopeAeadKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return KmsEnvelopeAeadKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(KmsEnvelopeAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
    }

    @Override
    protected void validateKeyFormat(KmsEnvelopeAeadKeyFormat format) throws GeneralSecurityException {
    }
}

