/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KmsAeadKey;
import com.google.crypto.tink.proto.KmsAeadKeyFormat;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class KmsAeadKeyManager
extends KeyManagerBase<Aead, KmsAeadKey, KmsAeadKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsAeadKey";

    public KmsAeadKeyManager() {
        super(Aead.class, KmsAeadKey.class, KmsAeadKeyFormat.class, TYPE_URL);
    }

    @Override
    public Aead getPrimitiveFromKey(KmsAeadKey keyProto) throws GeneralSecurityException {
        String keyUri = keyProto.getParams().getKeyUri();
        KmsClient kmsClient = KmsClients.get(keyUri);
        return kmsClient.getAead(keyUri);
    }

    @Override
    public KmsAeadKey newKeyFromFormat(KmsAeadKeyFormat format) throws GeneralSecurityException {
        return (KmsAeadKey)KmsAeadKey.newBuilder().setParams(format).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.REMOTE;
    }

    @Override
    protected KmsAeadKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return KmsAeadKey.parseFrom(byteString);
    }

    @Override
    protected KmsAeadKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return KmsAeadKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(KmsAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
    }

    @Override
    protected void validateKeyFormat(KmsAeadKeyFormat format) {
    }
}

