/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.proto.ChaCha20Poly1305Key;
import com.google.crypto.tink.proto.Empty;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.ChaCha20Poly1305;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class ChaCha20Poly1305KeyManager
extends KeyManagerBase<Aead, ChaCha20Poly1305Key, Empty> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.ChaCha20Poly1305Key";
    private static final int KEY_SIZE_IN_BYTES = 32;
    private static final int VERSION = 0;

    public ChaCha20Poly1305KeyManager() {
        super(Aead.class, ChaCha20Poly1305Key.class, Empty.class, TYPE_URL);
    }

    @Override
    public Aead getPrimitiveFromKey(ChaCha20Poly1305Key keyProto) throws GeneralSecurityException {
        return new ChaCha20Poly1305(keyProto.getKeyValue().toByteArray());
    }

    @Override
    protected ChaCha20Poly1305Key newKeyFromFormat(Empty unused) throws GeneralSecurityException {
        return (ChaCha20Poly1305Key)ChaCha20Poly1305Key.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(32))).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected ChaCha20Poly1305Key parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return ChaCha20Poly1305Key.parseFrom(byteString);
    }

    @Override
    protected Empty parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return Empty.parseFrom(byteString);
    }

    @Override
    protected void validateKey(ChaCha20Poly1305Key keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid ChaCha20Poly1305Key: incorrect key length");
        }
    }

    @Override
    protected void validateKeyFormat(Empty unused) throws GeneralSecurityException {
    }
}

