/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.proto.AesGcmKey;
import com.google.crypto.tink.proto.AesGcmKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesGcmJce;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class AesGcmKeyManager
extends KeyManagerBase<Aead, AesGcmKey, AesGcmKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesGcmKey";

    public AesGcmKeyManager() {
        super(Aead.class, AesGcmKey.class, AesGcmKeyFormat.class, TYPE_URL);
    }

    @Override
    protected Aead getPrimitiveFromKey(AesGcmKey key) throws GeneralSecurityException {
        return new AesGcmJce(key.getKeyValue().toByteArray());
    }

    @Override
    protected AesGcmKey newKeyFromFormat(AesGcmKeyFormat format) throws GeneralSecurityException {
        return (AesGcmKey)AesGcmKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected AesGcmKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesGcmKey.parseFrom(byteString);
    }

    @Override
    protected AesGcmKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesGcmKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(AesGcmKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        Validators.validateAesKeySize(key.getKeyValue().size());
    }

    @Override
    protected void validateKeyFormat(AesGcmKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getKeySize());
    }
}

