/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.proto.AesEaxKey;
import com.google.crypto.tink.proto.AesEaxKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesEaxJce;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class AesEaxKeyManager
extends KeyManagerBase<Aead, AesEaxKey, AesEaxKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesEaxKey";

    public AesEaxKeyManager() {
        super(Aead.class, AesEaxKey.class, AesEaxKeyFormat.class, TYPE_URL);
    }

    @Override
    public Aead getPrimitiveFromKey(AesEaxKey keyProto) throws GeneralSecurityException {
        return new AesEaxJce(keyProto.getKeyValue().toByteArray(), keyProto.getParams().getIvSize());
    }

    @Override
    public AesEaxKey newKeyFromFormat(AesEaxKeyFormat format) throws GeneralSecurityException {
        return (AesEaxKey)AesEaxKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected AesEaxKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesEaxKey.parseFrom(byteString);
    }

    @Override
    protected AesEaxKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesEaxKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(AesEaxKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        Validators.validateAesKeySize(key.getKeyValue().size());
        if (key.getParams().getIvSize() != 12 && key.getParams().getIvSize() != 16) {
            throw new GeneralSecurityException("invalid IV size; acceptable values have 12 or 16 bytes");
        }
    }

    @Override
    protected void validateKeyFormat(AesEaxKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getKeySize());
        if (format.getParams().getIvSize() != 12 && format.getParams().getIvSize() != 16) {
            throw new GeneralSecurityException("invalid IV size; acceptable values have 12 or 16 bytes");
        }
    }
}

