/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.proto.AesCtrKey;
import com.google.crypto.tink.proto.AesCtrKeyFormat;
import com.google.crypto.tink.proto.AesCtrParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesCtrJceCipher;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class AesCtrKeyManager
extends KeyManagerBase<IndCpaCipher, AesCtrKey, AesCtrKeyFormat> {
    private static final int VERSION = 0;
    static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesCtrKey";
    private static final int MIN_IV_SIZE_IN_BYTES = 12;

    public AesCtrKeyManager() {
        super(IndCpaCipher.class, AesCtrKey.class, AesCtrKeyFormat.class, TYPE_URL);
    }

    @Override
    public IndCpaCipher getPrimitiveFromKey(AesCtrKey keyProto) throws GeneralSecurityException {
        return new AesCtrJceCipher(keyProto.getKeyValue().toByteArray(), keyProto.getParams().getIvSize());
    }

    @Override
    public AesCtrKey newKeyFromFormat(AesCtrKeyFormat format) throws GeneralSecurityException {
        return (AesCtrKey)AesCtrKey.newBuilder().setParams(format.getParams()).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected AesCtrKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCtrKey.parseFrom(byteString);
    }

    @Override
    protected AesCtrKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCtrKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(AesCtrKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        Validators.validateAesKeySize(key.getKeyValue().size());
        this.validate(key.getParams());
    }

    @Override
    protected void validateKeyFormat(AesCtrKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getKeySize());
        this.validate(format.getParams());
    }

    private void validate(AesCtrParams params) throws GeneralSecurityException {
        if (params.getIvSize() < 12 || params.getIvSize() > 16) {
            throw new GeneralSecurityException("invalid IV size");
        }
    }
}

