/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.AesCtrKeyManager;
import com.google.crypto.tink.proto.AesCtrHmacAeadKey;
import com.google.crypto.tink.proto.AesCtrHmacAeadKeyFormat;
import com.google.crypto.tink.proto.AesCtrKey;
import com.google.crypto.tink.proto.HmacKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.EncryptThenAuthenticate;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class AesCtrHmacAeadKeyManager
extends KeyManagerBase<Aead, AesCtrHmacAeadKey, AesCtrHmacAeadKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey";

    public AesCtrHmacAeadKeyManager() throws GeneralSecurityException {
        super(Aead.class, AesCtrHmacAeadKey.class, AesCtrHmacAeadKeyFormat.class, TYPE_URL);
        Registry.registerKeyManager(new AesCtrKeyManager());
    }

    @Override
    public Aead getPrimitiveFromKey(AesCtrHmacAeadKey keyProto) throws GeneralSecurityException {
        return new EncryptThenAuthenticate(Registry.getPrimitive("type.googleapis.com/google.crypto.tink.AesCtrKey", (MessageLite)keyProto.getAesCtrKey(), IndCpaCipher.class), Registry.getPrimitive("type.googleapis.com/google.crypto.tink.HmacKey", (MessageLite)keyProto.getHmacKey(), Mac.class), keyProto.getHmacKey().getParams().getTagSize());
    }

    @Override
    public AesCtrHmacAeadKey newKeyFromFormat(AesCtrHmacAeadKeyFormat format) throws GeneralSecurityException {
        AesCtrKey aesCtrKey = (AesCtrKey)Registry.newKey("type.googleapis.com/google.crypto.tink.AesCtrKey", (MessageLite)format.getAesCtrKeyFormat());
        HmacKey hmacKey = (HmacKey)Registry.newKey("type.googleapis.com/google.crypto.tink.HmacKey", (MessageLite)format.getHmacKeyFormat());
        return (AesCtrHmacAeadKey)AesCtrHmacAeadKey.newBuilder().setAesCtrKey(aesCtrKey).setHmacKey(hmacKey).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected AesCtrHmacAeadKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCtrHmacAeadKey.parseFrom(byteString);
    }

    @Override
    protected AesCtrHmacAeadKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCtrHmacAeadKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKeyFormat(AesCtrHmacAeadKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getAesCtrKeyFormat().getKeySize());
    }

    @Override
    protected void validateKey(AesCtrHmacAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
    }
}

