/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

class AeadWrapper
implements PrimitiveWrapper<Aead> {
    private static final Logger logger = Logger.getLogger(AeadWrapper.class.getName());

    AeadWrapper() {
    }

    @Override
    public Aead wrap(PrimitiveSet<Aead> pset) throws GeneralSecurityException {
        return new WrappedAead(pset);
    }

    @Override
    public Class<Aead> getPrimitiveClass() {
        return Aead.class;
    }

    private static class WrappedAead
    implements Aead {
        private final PrimitiveSet<Aead> pSet;

        private WrappedAead(PrimitiveSet<Aead> pSet) {
            this.pSet = pSet;
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            return Bytes.concat(this.pSet.getPrimary().getIdentifier(), this.pSet.getPrimary().getPrimitive().encrypt(plaintext, associatedData));
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOfRange(ciphertext, 0, 5);
                byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                List<PrimitiveSet.Entry<Aead>> entries = this.pSet.getPrimitive(prefix);
                for (PrimitiveSet.Entry<Aead> entry : entries) {
                    try {
                        return entry.getPrimitive().decrypt(ciphertextNoPrefix, associatedData);
                    }
                    catch (GeneralSecurityException e) {
                        logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e.toString());
                    }
                }
            }
            List<PrimitiveSet.Entry<Aead>> entries = this.pSet.getRawPrimitives();
            for (PrimitiveSet.Entry<Aead> entry : entries) {
                try {
                    return entry.getPrimitive().decrypt(ciphertext, associatedData);
                }
                catch (GeneralSecurityException e) {
                }
            }
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

