/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.aead.AeadWrapper;
import com.google.crypto.tink.aead.AesCtrHmacAeadKeyManager;
import com.google.crypto.tink.aead.AesEaxKeyManager;
import com.google.crypto.tink.aead.AesGcmKeyManager;
import com.google.crypto.tink.aead.ChaCha20Poly1305KeyManager;
import com.google.crypto.tink.aead.KmsAeadKeyManager;
import com.google.crypto.tink.aead.KmsEnvelopeAeadKeyManager;
import com.google.crypto.tink.aead.XChaCha20Poly1305KeyManager;
import java.security.GeneralSecurityException;

class AeadCatalogue
implements Catalogue<Aead> {
    @Override
    public KeyManager<Aead> getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<Aead> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "aead": {
                keyManager = this.aeadKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<Aead> aeadKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey": {
                return new AesCtrHmacAeadKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.AesEaxKey": {
                return new AesEaxKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.AesGcmKey": {
                return new AesGcmKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.ChaCha20Poly1305Key": {
                return new ChaCha20Poly1305KeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.KmsAeadKey": {
                return new KmsAeadKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.KmsEnvelopeAeadKey": {
                return new KmsEnvelopeAeadKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.XChaCha20Poly1305Key": {
                return new XChaCha20Poly1305KeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'Aead' with key type '%s'.", typeUrl));
    }

    @Override
    public PrimitiveWrapper<Aead> getPrimitiveWrapper() {
        return new AeadWrapper();
    }
}

