/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.InternalKeyManager;
import com.google.crypto.tink.InternalPrivateKeyManager;
import com.google.crypto.tink.KeyManagerImpl;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.proto.KeyData;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

@Alpha
class PrivateKeyManagerImpl<PrimitiveT, KeyProtoT extends MessageLite, PublicKeyProtoT extends MessageLite>
extends KeyManagerImpl<PrimitiveT, KeyProtoT>
implements PrivateKeyManager<PrimitiveT> {
    private final InternalPrivateKeyManager<KeyProtoT, PublicKeyProtoT> privateKeyManager;
    private final InternalKeyManager<PublicKeyProtoT> publicKeyManager;

    public PrivateKeyManagerImpl(InternalPrivateKeyManager<KeyProtoT, PublicKeyProtoT> privateKeyManager, InternalKeyManager<PublicKeyProtoT> publicKeyManager, Class<PrimitiveT> primitiveClass) {
        super(privateKeyManager, primitiveClass);
        this.privateKeyManager = privateKeyManager;
        this.publicKeyManager = publicKeyManager;
    }

    @Override
    public KeyData getPublicKeyData(ByteString serializedKey) throws GeneralSecurityException {
        try {
            Object privKeyProto = this.privateKeyManager.parseKey(serializedKey);
            this.privateKeyManager.validateKey(privKeyProto);
            PublicKeyProtoT publicKeyProto = this.privateKeyManager.getPublicKey(privKeyProto);
            this.publicKeyManager.validateKey(publicKeyProto);
            return (KeyData)KeyData.newBuilder().setTypeUrl(this.publicKeyManager.getKeyType()).setValue(publicKeyProto.toByteString()).setKeyMaterialType(this.publicKeyManager.keyMaterialType()).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized proto of type ", e);
        }
    }
}

