/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.CryptoFormat;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class PrimitiveSet<P> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private ConcurrentMap<String, List<Entry<P>>> primitives = new ConcurrentHashMap<String, List<Entry<P>>>();
    private Entry<P> primary;
    private final Class<P> primitiveClass;

    public Entry<P> getPrimary() {
        return this.primary;
    }

    public List<Entry<P>> getRawPrimitives() {
        return this.getPrimitive(CryptoFormat.RAW_PREFIX);
    }

    public List<Entry<P>> getPrimitive(byte[] identifier) {
        List<Entry<P>> found = (List<Entry<P>>)this.primitives.get(new String(identifier, UTF_8));
        return found != null ? found : Collections.emptyList();
    }

    protected List<Entry<P>> getPrimitive(Keyset.Key key) throws GeneralSecurityException {
        return this.getPrimitive(CryptoFormat.getOutputPrefix(key));
    }

    public Collection<List<Entry<P>>> getAll() {
        return this.primitives.values();
    }

    private PrimitiveSet(Class<P> primitiveClass) {
        this.primitiveClass = primitiveClass;
    }

    public static <P> PrimitiveSet<P> newPrimitiveSet(Class<P> primitiveClass) {
        return new PrimitiveSet<P>(primitiveClass);
    }

    public void setPrimary(Entry<P> primary) {
        if (primary == null) {
            throw new IllegalArgumentException("the primary entry must be non-null");
        }
        if (primary.getStatus() != KeyStatusType.ENABLED) {
            throw new IllegalArgumentException("the primary entry has to be ENABLED");
        }
        List<Entry<P>> entries = this.getPrimitive(primary.getIdentifier());
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("the primary entry cannot be set to an entry which is not held by this primitive set");
        }
        this.primary = primary;
    }

    public Entry<P> addPrimitive(P primitive, Keyset.Key key) throws GeneralSecurityException {
        if (key.getStatus() != KeyStatusType.ENABLED) {
            throw new GeneralSecurityException("only ENABLED key is allowed");
        }
        Entry<P> entry = new Entry<P>(primitive, CryptoFormat.getOutputPrefix(key), key.getStatus(), key.getOutputPrefixType());
        ArrayList<Entry<P>> list = new ArrayList<Entry<P>>();
        list.add(entry);
        String identifier = new String(entry.getIdentifier(), UTF_8);
        List existing = this.primitives.put(identifier, Collections.unmodifiableList(list));
        if (existing != null) {
            ArrayList newList = new ArrayList();
            newList.addAll(existing);
            newList.add(entry);
            this.primitives.put(identifier, Collections.unmodifiableList(newList));
        }
        return entry;
    }

    public Class<P> getPrimitiveClass() {
        return this.primitiveClass;
    }

    public static final class Entry<P> {
        private final P primitive;
        private final byte[] identifier;
        private final KeyStatusType status;
        private final OutputPrefixType outputPrefixType;

        public Entry(P primitive, byte[] identifier, KeyStatusType status, OutputPrefixType outputPrefixType) {
            this.primitive = primitive;
            this.identifier = Arrays.copyOf(identifier, identifier.length);
            this.status = status;
            this.outputPrefixType = outputPrefixType;
        }

        public P getPrimitive() {
            return this.primitive;
        }

        public KeyStatusType getStatus() {
            return this.status;
        }

        public OutputPrefixType getOutputPrefixType() {
            return this.outputPrefixType;
        }

        public final byte[] getIdentifier() {
            if (this.identifier == null) {
                return null;
            }
            return Arrays.copyOf(this.identifier, this.identifier.length);
        }
    }
}

