/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetManager;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.Util;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.KeysetInfo;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.security.GeneralSecurityException;

public final class KeysetHandle {
    private Keyset keyset;

    private KeysetHandle(Keyset keyset) {
        this.keyset = keyset;
    }

    static final KeysetHandle fromKeyset(Keyset keyset) throws GeneralSecurityException {
        KeysetHandle.assertEnoughKeyMaterial(keyset);
        return new KeysetHandle(keyset);
    }

    Keyset getKeyset() {
        return this.keyset;
    }

    public KeysetInfo getKeysetInfo() {
        return Util.getKeysetInfo(this.keyset);
    }

    public static final KeysetHandle generateNew(KeyTemplate keyTemplate) throws GeneralSecurityException {
        return KeysetManager.withEmptyKeyset().rotate(keyTemplate).getKeysetHandle();
    }

    public static final KeysetHandle read(KeysetReader reader, Aead masterKey) throws GeneralSecurityException, IOException {
        EncryptedKeyset encryptedKeyset = reader.readEncrypted();
        KeysetHandle.assertEnoughEncryptedKeyMaterial(encryptedKeyset);
        return new KeysetHandle(KeysetHandle.decrypt(encryptedKeyset, masterKey));
    }

    public static final KeysetHandle readNoSecret(KeysetReader reader) throws GeneralSecurityException, IOException {
        try {
            Keyset keyset = reader.read();
            KeysetHandle.assertNoSecretKeyMaterial(keyset);
            return KeysetHandle.fromKeyset(keyset);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset");
        }
    }

    public static final KeysetHandle readNoSecret(byte[] serialized) throws GeneralSecurityException {
        try {
            Keyset keyset = Keyset.parseFrom(serialized);
            KeysetHandle.assertNoSecretKeyMaterial(keyset);
            return KeysetHandle.fromKeyset(keyset);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset");
        }
    }

    public void write(KeysetWriter keysetWriter, Aead masterKey) throws GeneralSecurityException, IOException {
        EncryptedKeyset encryptedKeyset = KeysetHandle.encrypt(this.keyset, masterKey);
        keysetWriter.write(encryptedKeyset);
    }

    public void writeNoSecret(KeysetWriter writer) throws GeneralSecurityException, IOException {
        KeysetHandle.assertNoSecretKeyMaterial(this.keyset);
        writer.write(this.keyset);
    }

    private static EncryptedKeyset encrypt(Keyset keyset, Aead masterKey) throws GeneralSecurityException {
        byte[] encryptedKeyset = masterKey.encrypt(keyset.toByteArray(), new byte[0]);
        try {
            Keyset keyset2 = Keyset.parseFrom(masterKey.decrypt(encryptedKeyset, new byte[0]));
            if (!keyset2.equals(keyset)) {
                throw new GeneralSecurityException("cannot encrypt keyset");
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset, corrupted key material");
        }
        return (EncryptedKeyset)EncryptedKeyset.newBuilder().setEncryptedKeyset(ByteString.copyFrom((byte[])encryptedKeyset)).setKeysetInfo(Util.getKeysetInfo(keyset)).build();
    }

    private static Keyset decrypt(EncryptedKeyset encryptedKeyset, Aead masterKey) throws GeneralSecurityException {
        try {
            Keyset keyset = Keyset.parseFrom(masterKey.decrypt(encryptedKeyset.getEncryptedKeyset().toByteArray(), new byte[0]));
            KeysetHandle.assertEnoughKeyMaterial(keyset);
            return keyset;
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset, corrupted key material");
        }
    }

    public KeysetHandle getPublicKeysetHandle() throws GeneralSecurityException {
        if (this.keyset == null) {
            throw new GeneralSecurityException("cleartext keyset is not available");
        }
        Keyset.Builder keysetBuilder = Keyset.newBuilder();
        for (Keyset.Key key : this.keyset.getKeyList()) {
            KeyData keyData = KeysetHandle.createPublicKeyData(key.getKeyData());
            keysetBuilder.addKey((Keyset.Key)((Keyset.Key.Builder)Keyset.Key.newBuilder().mergeFrom(key)).setKeyData(keyData).build());
        }
        keysetBuilder.setPrimaryKeyId(this.keyset.getPrimaryKeyId());
        return new KeysetHandle((Keyset)keysetBuilder.build());
    }

    private static KeyData createPublicKeyData(KeyData privateKeyData) throws GeneralSecurityException {
        if (privateKeyData.getKeyMaterialType() != KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE) {
            throw new GeneralSecurityException("The keyset contains a non-private key");
        }
        KeyData publicKeyData = Registry.getPublicKeyData(privateKeyData.getTypeUrl(), privateKeyData.getValue());
        KeysetHandle.validate(publicKeyData);
        return publicKeyData;
    }

    private static void validate(KeyData keyData) throws GeneralSecurityException {
        Registry.getPrimitive(keyData);
    }

    public String toString() {
        return this.getKeysetInfo().toString();
    }

    private static void assertNoSecretKeyMaterial(Keyset keyset) throws GeneralSecurityException {
        for (Keyset.Key key : keyset.getKeyList()) {
            if (key.getKeyData().getKeyMaterialType() != KeyData.KeyMaterialType.UNKNOWN_KEYMATERIAL && key.getKeyData().getKeyMaterialType() != KeyData.KeyMaterialType.SYMMETRIC && key.getKeyData().getKeyMaterialType() != KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE) continue;
            throw new GeneralSecurityException("keyset contains secret key material");
        }
    }

    public static void assertEnoughKeyMaterial(Keyset keyset) throws GeneralSecurityException {
        if (keyset == null || keyset.getKeyCount() <= 0) {
            throw new GeneralSecurityException("empty keyset");
        }
    }

    public static void assertEnoughEncryptedKeyMaterial(EncryptedKeyset keyset) throws GeneralSecurityException {
        if (keyset == null || keyset.getEncryptedKeyset().size() == 0) {
            throw new GeneralSecurityException("empty keyset");
        }
    }

    public <P> P getPrimitive(Class<P> classObject) throws GeneralSecurityException {
        PrimitiveSet<P> primitiveSet = Registry.getPrimitives(this, classObject);
        return Registry.wrap(primitiveSet);
    }

    public <P> P getPrimitive(KeyManager<P> customKeyManager, Class<P> classObject) throws GeneralSecurityException {
        if (customKeyManager == null) {
            throw new IllegalArgumentException("customKeyManager must be non-null.");
        }
        PrimitiveSet<P> primitiveSet = Registry.getPrimitives(this, customKeyManager, classObject);
        return Registry.wrap(primitiveSet);
    }
}

