/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.proto.KeyData;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

@Alpha
public abstract class KeyManagerBase<P, KeyProto extends MessageLite, KeyFormatProto extends MessageLite>
implements KeyManager<P> {
    private final Class<P> primitiveClass;
    private final Class<KeyProto> keyProtoClass;
    private final Class<KeyFormatProto> keyFormatProtoClass;
    private final String typeUrl;

    protected KeyManagerBase(Class<P> primitiveClass, Class<KeyProto> keyProtoClass, Class<KeyFormatProto> keyFormatProtoClass, String typeUrl) {
        this.primitiveClass = primitiveClass;
        this.keyProtoClass = keyProtoClass;
        this.keyFormatProtoClass = keyFormatProtoClass;
        this.typeUrl = typeUrl;
    }

    private static <Casted> Casted castOrSecurityException(Object objectToCast, String exceptionText, Class<Casted> classObject) throws GeneralSecurityException {
        if (!classObject.isInstance(objectToCast)) {
            throw new GeneralSecurityException(exceptionText);
        }
        Object castedObject = objectToCast;
        return (Casted)castedObject;
    }

    @Override
    public final P getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            KeyProto keyProto = this.parseKeyProto(serializedKey);
            return this.validateKeyAndGetPrimitive(keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("Failures parsing proto of type " + this.keyProtoClass.getName(), e);
        }
    }

    @Override
    public final P getPrimitive(MessageLite key) throws GeneralSecurityException {
        return this.validateKeyAndGetPrimitive((MessageLite)KeyManagerBase.castOrSecurityException(key, "Expected proto of type " + this.keyProtoClass.getName(), this.keyProtoClass));
    }

    @Override
    public final MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            return this.validateFormatAndCreateKey(this.parseKeyFormatProto(serializedKeyFormat));
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("Failures parsing proto of type " + this.keyFormatProtoClass.getName(), e);
        }
    }

    @Override
    public final MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        return this.validateFormatAndCreateKey((MessageLite)KeyManagerBase.castOrSecurityException(keyFormat, "Expected proto of type " + this.keyFormatProtoClass.getName(), this.keyFormatProtoClass));
    }

    @Override
    public final boolean doesSupport(String typeUrl) {
        return typeUrl.equals(this.getKeyType());
    }

    @Override
    public final String getKeyType() {
        return this.typeUrl;
    }

    @Override
    public final KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        KeyFormatProto format;
        try {
            format = this.parseKeyFormatProto(serializedKeyFormat);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("Unexpected proto", e);
        }
        KeyProto key = this.validateFormatAndCreateKey(format);
        return (KeyData)KeyData.newBuilder().setTypeUrl(this.getKeyType()).setValue(key.toByteString()).setKeyMaterialType(this.keyMaterialType()).build();
    }

    @Override
    public final Class<P> getPrimitiveClass() {
        return this.primitiveClass;
    }

    protected abstract void validateKey(KeyProto var1) throws GeneralSecurityException;

    protected abstract void validateKeyFormat(KeyFormatProto var1) throws GeneralSecurityException;

    protected abstract KeyData.KeyMaterialType keyMaterialType();

    protected abstract P getPrimitiveFromKey(KeyProto var1) throws GeneralSecurityException;

    private P validateKeyAndGetPrimitive(KeyProto keyProto) throws GeneralSecurityException {
        this.validateKey(keyProto);
        return this.getPrimitiveFromKey(keyProto);
    }

    protected abstract KeyProto newKeyFromFormat(KeyFormatProto var1) throws GeneralSecurityException;

    private KeyProto validateFormatAndCreateKey(KeyFormatProto keyFormatProto) throws GeneralSecurityException {
        this.validateKeyFormat(keyFormatProto);
        KeyProto result = this.newKeyFromFormat(keyFormatProto);
        this.validateKey(result);
        return result;
    }

    protected abstract KeyProto parseKeyProto(ByteString var1) throws InvalidProtocolBufferException;

    protected abstract KeyFormatProto parseKeyFormatProto(ByteString var1) throws InvalidProtocolBufferException;
}

