/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.keyderivation;

import com.google.crypto.tink.Configuration;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.InternalConfiguration;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.keyderivation.PrfBasedKeyDerivationKey;
import com.google.crypto.tink.keyderivation.internal.KeyDeriver;
import com.google.crypto.tink.keyderivation.internal.KeysetDeriverWrapper;
import com.google.crypto.tink.keyderivation.internal.PrfBasedKeyDeriver;
import com.google.crypto.tink.prf.HkdfPrfKey;
import com.google.crypto.tink.subtle.prf.HkdfStreamingPrf;
import com.google.crypto.tink.subtle.prf.StreamingPrf;
import java.security.GeneralSecurityException;

class KeysetDeriverConfigurationV1 {
    private static final InternalConfiguration INTERNAL_CONFIGURATION = KeysetDeriverConfigurationV1.create();
    private static final PrimitiveRegistry PRF_REGISTRY = KeysetDeriverConfigurationV1.createPrfRegistry();

    private KeysetDeriverConfigurationV1() {
    }

    private static InternalConfiguration create() {
        try {
            PrimitiveRegistry.Builder builder = PrimitiveRegistry.builder();
            KeysetDeriverWrapper.registerToInternalPrimitiveRegistry(builder);
            builder.registerPrimitiveConstructor(PrimitiveConstructor.create(KeysetDeriverConfigurationV1::createHkdfPrfBasedKeyDeriver, PrfBasedKeyDerivationKey.class, KeyDeriver.class));
            return InternalConfiguration.createFromPrimitiveRegistry(builder.build());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PrimitiveRegistry createPrfRegistry() {
        try {
            return PrimitiveRegistry.builder().registerPrimitiveConstructor(PrimitiveConstructor.create(HkdfStreamingPrf::create, HkdfPrfKey.class, StreamingPrf.class)).build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Configuration get() throws GeneralSecurityException {
        if (TinkFipsUtil.useOnlyFips()) {
            throw new GeneralSecurityException("Cannot use non-FIPS-compliant KeysetDeriverConfigurationV1 in FIPS mode");
        }
        return INTERNAL_CONFIGURATION;
    }

    private static KeyDeriver createHkdfPrfBasedKeyDeriver(PrfBasedKeyDerivationKey key) throws GeneralSecurityException {
        KeyDeriver deriver = PrfBasedKeyDeriver.createWithPrfPrimitiveRegistry(PRF_REGISTRY, key);
        Key unused = deriver.deriveKey(new byte[]{1});
        return deriver;
    }
}

