/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import java.security.SecureRandom;

public final class Random {
    private static final ThreadLocal<SecureRandom> localRandom = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return Random.newDefaultSecureRandom();
        }
    };

    private static SecureRandom newDefaultSecureRandom() {
        SecureRandom retval = new SecureRandom();
        retval.nextLong();
        return retval;
    }

    public static byte[] randBytes(int size) {
        byte[] rand = new byte[size];
        localRandom.get().nextBytes(rand);
        return rand;
    }

    public static final int randInt(int max) {
        return localRandom.get().nextInt(max);
    }
}

