/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.proto.AesGcmHkdfStreamingKey;
import com.google.crypto.tink.proto.AesGcmHkdfStreamingKeyFormat;
import com.google.crypto.tink.proto.AesGcmHkdfStreamingParams;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.streamingaead.StreamingAeadUtil;
import com.google.crypto.tink.subtle.AesGcmHkdfStreaming;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class AesGcmHkdfStreamingKeyManager
implements KeyManager<StreamingAead> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesGcmHkdfStreamingKey";

    AesGcmHkdfStreamingKeyManager() {
    }

    @Override
    public StreamingAead getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            AesGcmHkdfStreamingKey keyProto = AesGcmHkdfStreamingKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected AesGcmHkdfStreamingKey proto");
        }
    }

    @Override
    public StreamingAead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof AesGcmHkdfStreamingKey)) {
            throw new GeneralSecurityException("expected AesGcmHkdfStreamingKey proto");
        }
        AesGcmHkdfStreamingKey keyProto = (AesGcmHkdfStreamingKey)key;
        this.validate(keyProto);
        return new AesGcmHkdfStreaming(keyProto.getKeyValue().toByteArray(), StreamingAeadUtil.toHmacAlgo(keyProto.getParams().getHkdfHashType()), keyProto.getParams().getDerivedKeySize(), keyProto.getParams().getCiphertextSegmentSize(), 0);
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            AesGcmHkdfStreamingKeyFormat format = AesGcmHkdfStreamingKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesGcmHkdfStreamingKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof AesGcmHkdfStreamingKeyFormat)) {
            throw new GeneralSecurityException("expected AesGcmHkdfStreamingKeyFormat proto");
        }
        AesGcmHkdfStreamingKeyFormat format = (AesGcmHkdfStreamingKeyFormat)keyFormat;
        this.validate(format);
        return AesGcmHkdfStreamingKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        AesGcmHkdfStreamingKey key = (AesGcmHkdfStreamingKey)this.newKey(serializedKeyFormat);
        return (KeyData)KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(AesGcmHkdfStreamingKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        this.validate(key.getParams());
    }

    private void validate(AesGcmHkdfStreamingKeyFormat format) throws GeneralSecurityException {
        if (format.getKeySize() < 16) {
            throw new GeneralSecurityException("key_size must be at least 16 bytes");
        }
        this.validate(format.getParams());
    }

    private void validate(AesGcmHkdfStreamingParams params) throws GeneralSecurityException {
        Validators.validateAesKeySize(params.getDerivedKeySize());
        if (params.getHkdfHashType() == HashType.UNKNOWN_HASH) {
            throw new GeneralSecurityException("unknown HKDF hash type");
        }
        if (params.getCiphertextSegmentSize() < params.getDerivedKeySize() + 8) {
            throw new GeneralSecurityException("ciphertext_segment_size must be at least (derived_key_size + 8)");
        }
    }
}

