/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetManager;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.integration.android.AndroidKeystoreKmsClient;
import com.google.crypto.tink.integration.android.SharedPrefKeysetReader;
import com.google.crypto.tink.integration.android.SharedPrefKeysetWriter;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.annotation.concurrent.GuardedBy;

public final class AndroidKeysetManager {
    private static final String TAG = AndroidKeysetManager.class.getName();
    private final KeysetReader reader;
    private final KeysetWriter writer;
    private final boolean useKeystore;
    private final Aead masterKey;
    private final KeyTemplate keyTemplate;
    @GuardedBy(value="this")
    private KeysetManager keysetManager;

    private AndroidKeysetManager(Builder builder) throws GeneralSecurityException, IOException {
        this.reader = builder.reader;
        if (this.reader == null) {
            throw new IllegalArgumentException("need to specify where to read the keyset from with Builder#withSharedPref");
        }
        this.writer = builder.writer;
        if (this.writer == null) {
            throw new IllegalArgumentException("need to specify where to write the keyset to with Builder#withSharedPref");
        }
        this.useKeystore = builder.useKeystore;
        if (this.useKeystore && builder.masterKeyUri == null) {
            throw new IllegalArgumentException("need a master key URI, please set it with Builder#masterKeyUri");
        }
        this.masterKey = this.shouldUseKeystore() ? AndroidKeystoreKmsClient.getOrGenerateNewAeadKey(builder.masterKeyUri) : null;
        this.keyTemplate = builder.keyTemplate;
        this.keysetManager = this.readOrGenerateNewKeyset();
    }

    @GuardedBy(value="this")
    public synchronized KeysetHandle getKeysetHandle() throws GeneralSecurityException {
        return this.keysetManager.getKeysetHandle();
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager rotate(KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.rotate(keyTemplate);
        this.write(this.keysetManager);
        return this;
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager add(KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.add(keyTemplate);
        this.write(this.keysetManager);
        return this;
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager setPrimary(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.setPrimary(keyId);
        this.write(this.keysetManager);
        return this;
    }

    @Deprecated
    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager promote(int keyId) throws GeneralSecurityException {
        return this.setPrimary(keyId);
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager enable(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.enable(keyId);
        this.write(this.keysetManager);
        return this;
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager disable(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.disable(keyId);
        this.write(this.keysetManager);
        return this;
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager delete(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.delete(keyId);
        this.write(this.keysetManager);
        return this;
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager destroy(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.destroy(keyId);
        this.write(this.keysetManager);
        return this;
    }

    private KeysetManager readOrGenerateNewKeyset() throws GeneralSecurityException, IOException {
        try {
            return this.read();
        }
        catch (IOException e) {
            Log.i((String)TAG, (String)("cannot read keyset: " + e.toString()));
            if (this.keyTemplate != null) {
                KeysetManager manager = KeysetManager.withEmptyKeyset().rotate(this.keyTemplate);
                this.write(manager);
                return manager;
            }
            throw new GeneralSecurityException("cannot obtain keyset handle");
        }
    }

    private KeysetManager read() throws GeneralSecurityException, IOException {
        if (this.shouldUseKeystore()) {
            try {
                return KeysetManager.withKeysetHandle(KeysetHandle.read(this.reader, this.masterKey));
            }
            catch (InvalidProtocolBufferException | GeneralSecurityException e) {
                Log.i((String)TAG, (String)("cannot decrypt keyset: " + e.toString()));
            }
        }
        KeysetHandle handle = CleartextKeysetHandle.read(this.reader);
        if (this.shouldUseKeystore()) {
            handle.write(this.writer, this.masterKey);
        }
        return KeysetManager.withKeysetHandle(handle);
    }

    private void write(KeysetManager manager) throws GeneralSecurityException {
        try {
            if (this.shouldUseKeystore()) {
                manager.getKeysetHandle().write(this.writer, this.masterKey);
            } else {
                CleartextKeysetHandle.write(manager.getKeysetHandle(), this.writer);
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private boolean shouldUseKeystore() {
        return this.useKeystore && Build.VERSION.SDK_INT >= 23;
    }

    public static final class Builder {
        private KeysetReader reader = null;
        private KeysetWriter writer = null;
        private String masterKeyUri = null;
        private boolean useKeystore = true;
        private KeyTemplate keyTemplate = null;

        public Builder withSharedPref(Context context, String keysetName, String prefFileName) throws IOException {
            if (context == null) {
                throw new IllegalArgumentException("need an Android context");
            }
            if (keysetName == null) {
                throw new IllegalArgumentException("need a keyset name");
            }
            this.reader = new SharedPrefKeysetReader(context, keysetName, prefFileName);
            this.writer = new SharedPrefKeysetWriter(context, keysetName, prefFileName);
            return this;
        }

        public Builder withMasterKeyUri(String val) {
            if (!val.startsWith("android-keystore://")) {
                throw new IllegalArgumentException("key URI must start with android-keystore://");
            }
            this.masterKeyUri = val;
            return this;
        }

        public Builder withKeyTemplate(KeyTemplate val) {
            this.keyTemplate = val;
            return this;
        }

        public Builder doNotUseKeystore() {
            this.useKeystore = false;
            return this;
        }

        public AndroidKeysetManager build() throws GeneralSecurityException, IOException {
            return new AndroidKeysetManager(this);
        }
    }
}

