/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.proto;

import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.HmacParamsOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;

public final class HmacParams
extends GeneratedMessageLite<HmacParams, Builder>
implements HmacParamsOrBuilder {
    public static final int HASH_FIELD_NUMBER = 1;
    private int hash_;
    public static final int TAG_SIZE_FIELD_NUMBER = 2;
    private int tagSize_;
    private static final HmacParams DEFAULT_INSTANCE = new HmacParams();
    private static volatile Parser<HmacParams> PARSER;

    private HmacParams() {
    }

    @Override
    public int getHashValue() {
        return this.hash_;
    }

    @Override
    public HashType getHash() {
        HashType result = HashType.forNumber(this.hash_);
        return result == null ? HashType.UNRECOGNIZED : result;
    }

    private void setHashValue(int value) {
        this.hash_ = value;
    }

    private void setHash(HashType value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.hash_ = value.getNumber();
    }

    private void clearHash() {
        this.hash_ = 0;
    }

    @Override
    public int getTagSize() {
        return this.tagSize_;
    }

    private void setTagSize(int value) {
        this.tagSize_ = value;
    }

    private void clearTagSize() {
        this.tagSize_ = 0;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.hash_ != HashType.UNKNOWN_HASH.getNumber()) {
            output.writeEnum(1, this.hash_);
        }
        if (this.tagSize_ != 0) {
            output.writeUInt32(2, this.tagSize_);
        }
    }

    public int getSerializedSize() {
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.hash_ != HashType.UNKNOWN_HASH.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.hash_);
        }
        if (this.tagSize_ != 0) {
            size += CodedOutputStream.computeUInt32Size((int)2, (int)this.tagSize_);
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public static HmacParams parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data);
    }

    public static HmacParams parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HmacParams parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data);
    }

    public static HmacParams parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HmacParams parseFrom(InputStream input) throws IOException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static HmacParams parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HmacParams parseDelimitedFrom(InputStream input) throws IOException {
        return (HmacParams)HmacParams.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static HmacParams parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HmacParams)HmacParams.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HmacParams parseFrom(CodedInputStream input) throws IOException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input);
    }

    public static HmacParams parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HmacParams)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HmacParams prototype) {
        return (Builder)((Builder)DEFAULT_INSTANCE.toBuilder()).mergeFrom(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new HmacParams();
            }
            case IS_INITIALIZED: {
                return DEFAULT_INSTANCE;
            }
            case MAKE_IMMUTABLE: {
                return null;
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case VISIT: {
                GeneratedMessageLite.Visitor visitor = (GeneratedMessageLite.Visitor)arg0;
                HmacParams other = (HmacParams)arg1;
                this.hash_ = visitor.visitInt(this.hash_ != 0, this.hash_, other.hash_ != 0, other.hash_);
                this.tagSize_ = visitor.visitInt(this.tagSize_ != 0, this.tagSize_, other.tagSize_ != 0, other.tagSize_);
                if (visitor != GeneratedMessageLite.MergeFromVisitor.INSTANCE) return this;
                return this;
            }
            case MERGE_FROM_STREAM: {
                CodedInputStream input = (CodedInputStream)arg0;
                ExtensionRegistryLite extensionRegistry = (ExtensionRegistryLite)arg1;
                try {
                    boolean done = false;
                    block23: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block23;
                            }
                            default: {
                                if (input.skipField(tag)) continue block23;
                                done = true;
                                continue block23;
                            }
                            case 8: {
                                int rawValue;
                                this.hash_ = rawValue = input.readEnum();
                                continue block23;
                            }
                            case 16: 
                        }
                        this.tagSize_ = input.readUInt32();
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e.setUnfinishedMessage((MessageLite)this));
                }
                catch (IOException e) {
                    throw new RuntimeException(new InvalidProtocolBufferException(e.getMessage()).setUnfinishedMessage((MessageLite)this));
                }
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                if (PARSER != null) return PARSER;
                Class<HmacParams> clazz = HmacParams.class;
                synchronized (HmacParams.class) {
                    if (PARSER != null) return PARSER;
                    PARSER = new GeneratedMessageLite.DefaultInstanceBasedParser((GeneratedMessageLite)DEFAULT_INSTANCE);
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return PARSER;
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public static HmacParams getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<HmacParams> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        DEFAULT_INSTANCE.makeImmutable();
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<HmacParams, Builder>
    implements HmacParamsOrBuilder {
        private Builder() {
            super((GeneratedMessageLite)DEFAULT_INSTANCE);
        }

        @Override
        public int getHashValue() {
            return ((HmacParams)this.instance).getHashValue();
        }

        public Builder setHashValue(int value) {
            this.copyOnWrite();
            ((HmacParams)this.instance).setHashValue(value);
            return this;
        }

        @Override
        public HashType getHash() {
            return ((HmacParams)this.instance).getHash();
        }

        public Builder setHash(HashType value) {
            this.copyOnWrite();
            ((HmacParams)this.instance).setHash(value);
            return this;
        }

        public Builder clearHash() {
            this.copyOnWrite();
            ((HmacParams)this.instance).clearHash();
            return this;
        }

        @Override
        public int getTagSize() {
            return ((HmacParams)this.instance).getTagSize();
        }

        public Builder setTagSize(int value) {
            this.copyOnWrite();
            ((HmacParams)this.instance).setTagSize(value);
            return this;
        }

        public Builder clearTagSize() {
            this.copyOnWrite();
            ((HmacParams)this.instance).clearTagSize();
            return this;
        }
    }
}

