/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.NonceBasedStreamingAead;
import com.google.crypto.tink.subtle.StreamSegmentDecrypter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

class StreamingAeadDecryptingStream
extends FilterInputStream {
    private static final int PLAINTEXT_SEGMENT_EXTRA_SIZE = 16;
    private ByteBuffer ciphertextSegment;
    private ByteBuffer plaintextSegment;
    private int headerLength;
    private boolean headerRead;
    private boolean endOfCiphertext;
    private boolean endOfPlaintext;
    private boolean definedState;
    private byte[] aad;
    private int segmentNr;
    private final StreamSegmentDecrypter decrypter;
    private final int ciphertextSegmentSize;
    private final int firstCiphertextSegmentSize;

    public StreamingAeadDecryptingStream(NonceBasedStreamingAead streamAead, InputStream ciphertextStream, byte[] associatedData) throws GeneralSecurityException, IOException {
        super(ciphertextStream);
        this.decrypter = streamAead.newStreamSegmentDecrypter();
        this.headerLength = streamAead.getHeaderLength();
        this.headerRead = false;
        this.aad = Arrays.copyOf(associatedData, associatedData.length);
        this.ciphertextSegmentSize = streamAead.getCiphertextSegmentSize();
        this.ciphertextSegment = ByteBuffer.allocate(this.ciphertextSegmentSize + 1);
        this.ciphertextSegment.limit(0);
        this.firstCiphertextSegmentSize = this.ciphertextSegmentSize - streamAead.getCiphertextOffset();
        this.plaintextSegment = ByteBuffer.allocate(streamAead.getPlaintextSegmentSize() + 16);
        this.plaintextSegment.limit(0);
        this.headerRead = false;
        this.endOfCiphertext = false;
        this.endOfPlaintext = false;
        this.segmentNr = 0;
        this.definedState = true;
    }

    private void readHeader() throws IOException {
        assert (!this.headerRead);
        byte[] header = new byte[this.headerLength];
        int bytesRead = this.in.read(header);
        if (bytesRead != this.headerLength) {
            this.setUndefinedState();
            throw new IOException("Ciphertext is too short");
        }
        try {
            this.decrypter.init(ByteBuffer.wrap(header), this.aad);
        }
        catch (GeneralSecurityException ex) {
            throw new IOException(ex);
        }
        this.headerRead = true;
    }

    private void setUndefinedState() {
        this.definedState = false;
        this.plaintextSegment.limit(0);
    }

    private void loadSegment() throws IOException {
        while (!this.endOfCiphertext && this.ciphertextSegment.remaining() > 0) {
            int read = this.in.read(this.ciphertextSegment.array(), this.ciphertextSegment.position(), this.ciphertextSegment.remaining());
            if (read > 0) {
                this.ciphertextSegment.position(this.ciphertextSegment.position() + read);
                continue;
            }
            if (read == -1) {
                this.endOfCiphertext = true;
                continue;
            }
            if (read != 0) continue;
            throw new IOException("Could not read bytes from the ciphertext stream");
        }
        byte lastByte = 0;
        if (!this.endOfCiphertext) {
            lastByte = this.ciphertextSegment.get(this.ciphertextSegment.position() - 1);
            this.ciphertextSegment.position(this.ciphertextSegment.position() - 1);
        }
        this.ciphertextSegment.flip();
        this.plaintextSegment.clear();
        try {
            this.decrypter.decryptSegment(this.ciphertextSegment, this.segmentNr, this.endOfCiphertext, this.plaintextSegment);
        }
        catch (GeneralSecurityException ex) {
            this.setUndefinedState();
            throw new IOException(ex.getMessage() + "\n" + this.toString() + "\nsegmentNr:" + this.segmentNr + " endOfCiphertext:" + this.endOfCiphertext, ex);
        }
        ++this.segmentNr;
        this.plaintextSegment.flip();
        this.ciphertextSegment.clear();
        if (!this.endOfCiphertext) {
            this.ciphertextSegment.clear();
            this.ciphertextSegment.limit(this.ciphertextSegmentSize + 1);
            this.ciphertextSegment.put(lastByte);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] oneByte = new byte[1];
        int ret = this.read(oneByte, 0, 1);
        if (ret == 1) {
            return oneByte[0] & 0xFF;
        }
        if (ret == -1) {
            return ret;
        }
        throw new IOException("Reading failed");
    }

    @Override
    public int read(byte[] dst) throws IOException {
        return this.read(dst, 0, dst.length);
    }

    @Override
    public synchronized int read(byte[] dst, int offset, int length) throws IOException {
        int bytesRead;
        int sliceSize;
        if (!this.definedState) {
            throw new IOException("This StreamingAeadDecryptingStream is in an undefined state");
        }
        if (!this.headerRead) {
            this.readHeader();
            this.ciphertextSegment.clear();
            this.ciphertextSegment.limit(this.firstCiphertextSegmentSize + 1);
        }
        if (this.endOfPlaintext) {
            return -1;
        }
        for (bytesRead = 0; bytesRead < length; bytesRead += sliceSize) {
            if (this.plaintextSegment.remaining() == 0) {
                if (this.endOfCiphertext) {
                    this.endOfPlaintext = true;
                    break;
                }
                this.loadSegment();
            }
            sliceSize = Math.min(this.plaintextSegment.remaining(), length - bytesRead);
            this.plaintextSegment.get(dst, bytesRead + offset, sliceSize);
        }
        if (bytesRead == 0 && this.endOfPlaintext) {
            return -1;
        }
        return bytesRead;
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized int available() {
        return this.plaintextSegment.remaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public synchronized String toString() {
        StringBuilder res = new StringBuilder();
        res.append("StreamingAeadDecryptingStream").append("\nsegmentNr:").append(this.segmentNr).append("\nciphertextSegmentSize:").append(this.ciphertextSegmentSize).append("\nheaderRead:").append(this.headerRead).append("\nendOfCiphertext:").append(this.endOfCiphertext).append("\nendOfPlaintext:").append(this.endOfPlaintext).append("\ndefinedState:").append(this.definedState).append("\nciphertextSgement").append(" position:").append(this.ciphertextSegment.position()).append(" limit:").append(this.ciphertextSegment.limit()).append("\nplaintextSegment").append(" position:").append(this.plaintextSegment.position()).append(" limit:").append(this.plaintextSegment.limit());
        return res.toString();
    }
}

