/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.proto.AesEaxKey;
import com.google.crypto.tink.proto.AesEaxKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.AesEaxJce;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class AesEaxKeyManager
implements KeyManager<Aead> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesEaxKey";

    AesEaxKeyManager() {
    }

    @Override
    public Aead getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            AesEaxKey keyProto = AesEaxKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesEaxKey proto", e);
        }
    }

    @Override
    public Aead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof AesEaxKey)) {
            throw new GeneralSecurityException("expected AesEaxKey proto");
        }
        AesEaxKey keyProto = (AesEaxKey)key;
        this.validate(keyProto);
        return new AesEaxJce(keyProto.getKeyValue().toByteArray(), keyProto.getParams().getIvSize());
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            AesEaxKeyFormat format = AesEaxKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesEaxKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof AesEaxKeyFormat)) {
            throw new GeneralSecurityException("expected AesEaxKeyFormat proto");
        }
        AesEaxKeyFormat format = (AesEaxKeyFormat)keyFormat;
        this.validate(format);
        return AesEaxKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        AesEaxKey key = (AesEaxKey)this.newKey(serializedKeyFormat);
        return (KeyData)KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(AesEaxKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        Validators.validateAesKeySize(key.getKeyValue().size());
        if (key.getParams().getIvSize() != 12 && key.getParams().getIvSize() != 16) {
            throw new GeneralSecurityException("invalid IV size; acceptable values have 12 or 16 bytes");
        }
    }

    private void validate(AesEaxKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getKeySize());
        if (format.getParams().getIvSize() != 12 && format.getParams().getIvSize() != 16) {
            throw new GeneralSecurityException("invalid IV size; acceptable values have 12 or 16 bytes");
        }
    }
}

