/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public final class AeadFactory {
    private static final Logger logger = Logger.getLogger(AeadFactory.class.getName());

    public static Aead getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return AeadFactory.getPrimitive(keysetHandle, null);
    }

    public static Aead getPrimitive(KeysetHandle keysetHandle, KeyManager<Aead> keyManager) throws GeneralSecurityException {
        final PrimitiveSet<Aead> pset = Registry.getPrimitives(keysetHandle, keyManager);
        AeadFactory.validate(pset);
        return new Aead(){

            @Override
            public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
                return Bytes.concat(pset.getPrimary().getIdentifier(), ((Aead)pset.getPrimary().getPrimitive()).encrypt(plaintext, associatedData));
            }

            @Override
            public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
                if (ciphertext.length > 5) {
                    byte[] prefix = Arrays.copyOfRange(ciphertext, 0, 5);
                    byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                    List entries = pset.getPrimitive(prefix);
                    for (PrimitiveSet.Entry entry : entries) {
                        try {
                            return ((Aead)entry.getPrimitive()).decrypt(ciphertextNoPrefix, associatedData);
                        }
                        catch (GeneralSecurityException e) {
                            logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e.toString());
                        }
                    }
                }
                List entries = pset.getRawPrimitives();
                for (PrimitiveSet.Entry entry : entries) {
                    try {
                        return ((Aead)entry.getPrimitive()).decrypt(ciphertext, associatedData);
                    }
                    catch (GeneralSecurityException e) {
                    }
                }
                throw new GeneralSecurityException("decryption failed");
            }
        };
    }

    private static void validate(PrimitiveSet<Aead> pset) throws GeneralSecurityException {
        for (Collection collection : pset.getAll()) {
            for (PrimitiveSet.Entry entry : collection) {
                if (entry.getPrimitive() instanceof Aead) continue;
                throw new GeneralSecurityException("invalid AEAD key material");
            }
        }
    }
}

