/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.EllipticCurve;

public final class EcdsaSignJce
implements PublicKeySign {
    private final ECPrivateKey privateKey;
    private final String signatureAlgorithm;
    private final EllipticCurves.EcdsaEncoding encoding;

    public EcdsaSignJce(ECPrivateKey priv, String signatureAlgorithm, EllipticCurves.EcdsaEncoding encoding) throws GeneralSecurityException {
        Validators.validateSignatureHash(signatureAlgorithm);
        this.privateKey = priv;
        this.signatureAlgorithm = signatureAlgorithm;
        this.encoding = encoding;
    }

    @Override
    public byte[] sign(byte[] data) throws GeneralSecurityException {
        Signature signer = EngineFactory.SIGNATURE.getInstance(this.signatureAlgorithm);
        signer.initSign(this.privateKey);
        signer.update(data);
        byte[] signature = signer.sign();
        if (this.encoding == EllipticCurves.EcdsaEncoding.IEEE_P1363) {
            EllipticCurve curve = this.privateKey.getParams().getCurve();
            signature = EllipticCurves.ecdsaDer2Ieee(signature, 2 * EllipticCurves.fieldSizeInBytes(curve));
        }
        return signature;
    }
}

