/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.PemKeyType;
import com.google.crypto.tink.proto.EcdsaParams;
import com.google.crypto.tink.proto.EcdsaPublicKey;
import com.google.crypto.tink.proto.EcdsaSignatureEncoding;
import com.google.crypto.tink.proto.EllipticCurveType;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.proto.RsaSsaPkcs1Params;
import com.google.crypto.tink.proto.RsaSsaPkcs1PublicKey;
import com.google.crypto.tink.proto.RsaSsaPssParams;
import com.google.crypto.tink.proto.RsaSsaPssPublicKey;
import com.google.crypto.tink.signature.EcdsaVerifyKeyManager;
import com.google.crypto.tink.signature.RsaSsaPkcs1VerifyKeyManager;
import com.google.crypto.tink.signature.RsaSsaPssVerifyKeyManager;
import com.google.crypto.tink.signature.internal.SigUtil;
import com.google.crypto.tink.subtle.Random;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.Key;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class SignaturePemKeysetReader
implements KeysetReader {
    private List<PemKey> pemKeys;

    SignaturePemKeysetReader(List<PemKey> pemKeys) {
        this.pemKeys = pemKeys;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Keyset read() throws IOException {
        Keyset.Builder keyset = Keyset.newBuilder();
        for (PemKey pemKey : this.pemKeys) {
            Keyset.Key key = SignaturePemKeysetReader.readKey(pemKey.reader, pemKey.type);
            while (key != null) {
                keyset.addKey(key);
                key = SignaturePemKeysetReader.readKey(pemKey.reader, pemKey.type);
            }
        }
        if (keyset.getKeyCount() == 0) {
            throw new IOException("cannot find any key");
        }
        keyset.setPrimaryKeyId(keyset.getKey(0).getKeyId());
        return (Keyset)keyset.build();
    }

    @Override
    public EncryptedKeyset readEncrypted() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    private static Keyset.Key readKey(BufferedReader reader, PemKeyType pemKeyType) throws IOException {
        KeyData keyData;
        Key key = pemKeyType.readKey(reader);
        if (key == null) {
            return null;
        }
        if (key instanceof RSAPublicKey) {
            keyData = SignaturePemKeysetReader.convertRsaPublicKey(pemKeyType, (RSAPublicKey)key);
        } else if (key instanceof ECPublicKey) {
            keyData = SignaturePemKeysetReader.convertEcPublicKey(pemKeyType, (ECPublicKey)key);
        } else {
            return null;
        }
        return (Keyset.Key)Keyset.Key.newBuilder().setKeyData(keyData).setStatus(KeyStatusType.ENABLED).setOutputPrefixType(OutputPrefixType.RAW).setKeyId(Random.randInt()).build();
    }

    private static KeyData convertRsaPublicKey(PemKeyType pemKeyType, RSAPublicKey key) throws IOException {
        if (pemKeyType.algorithm.equals("RSASSA-PKCS1-v1_5")) {
            RsaSsaPkcs1Params params = (RsaSsaPkcs1Params)RsaSsaPkcs1Params.newBuilder().setHashType(SignaturePemKeysetReader.getHashType(pemKeyType)).build();
            RsaSsaPkcs1PublicKey pkcs1PubKey = (RsaSsaPkcs1PublicKey)RsaSsaPkcs1PublicKey.newBuilder().setVersion(0).setParams(params).setE(SigUtil.toUnsignedIntByteString(key.getPublicExponent())).setN(SigUtil.toUnsignedIntByteString(key.getModulus())).build();
            return (KeyData)KeyData.newBuilder().setTypeUrl(RsaSsaPkcs1VerifyKeyManager.getKeyType()).setValue(pkcs1PubKey.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        if (pemKeyType.algorithm.equals("RSASSA-PSS")) {
            RsaSsaPssParams params = (RsaSsaPssParams)RsaSsaPssParams.newBuilder().setSigHash(SignaturePemKeysetReader.getHashType(pemKeyType)).setMgf1Hash(SignaturePemKeysetReader.getHashType(pemKeyType)).setSaltLength(SignaturePemKeysetReader.getDigestSizeInBytes(pemKeyType)).build();
            RsaSsaPssPublicKey pssPubKey = (RsaSsaPssPublicKey)RsaSsaPssPublicKey.newBuilder().setVersion(0).setParams(params).setE(SigUtil.toUnsignedIntByteString(key.getPublicExponent())).setN(SigUtil.toUnsignedIntByteString(key.getModulus())).build();
            return (KeyData)KeyData.newBuilder().setTypeUrl(RsaSsaPssVerifyKeyManager.getKeyType()).setValue(pssPubKey.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        throw new IOException("unsupported RSA signature algorithm: " + pemKeyType.algorithm);
    }

    private static KeyData convertEcPublicKey(PemKeyType pemKeyType, ECPublicKey key) throws IOException {
        if (pemKeyType.algorithm.equals("ECDSA")) {
            EcdsaParams params = (EcdsaParams)EcdsaParams.newBuilder().setHashType(SignaturePemKeysetReader.getHashType(pemKeyType)).setCurve(SignaturePemKeysetReader.getCurveType(pemKeyType)).setEncoding(EcdsaSignatureEncoding.DER).build();
            EcdsaPublicKey ecdsaPubKey = (EcdsaPublicKey)EcdsaPublicKey.newBuilder().setVersion(0).setParams(params).setX(SigUtil.toUnsignedIntByteString(key.getW().getAffineX())).setY(SigUtil.toUnsignedIntByteString(key.getW().getAffineY())).build();
            return (KeyData)KeyData.newBuilder().setTypeUrl(EcdsaVerifyKeyManager.getKeyType()).setValue(ecdsaPubKey.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        throw new IOException("unsupported EC signature algorithm: " + pemKeyType.algorithm);
    }

    private static HashType getHashType(PemKeyType pemKeyType) {
        switch (pemKeyType.hash) {
            case SHA256: {
                return HashType.SHA256;
            }
            case SHA384: {
                return HashType.SHA384;
            }
            case SHA512: {
                return HashType.SHA512;
            }
        }
        throw new IllegalArgumentException("unsupported hash type: " + pemKeyType.hash.name());
    }

    private static int getDigestSizeInBytes(PemKeyType pemKeyType) {
        switch (pemKeyType.hash) {
            case SHA256: {
                return 32;
            }
            case SHA384: {
                return 48;
            }
            case SHA512: {
                return 64;
            }
        }
        throw new IllegalArgumentException("unsupported hash type: " + pemKeyType.hash.name());
    }

    private static EllipticCurveType getCurveType(PemKeyType pemKeyType) {
        switch (pemKeyType.keySizeInBits) {
            case 256: {
                return EllipticCurveType.NIST_P256;
            }
            case 384: {
                return EllipticCurveType.NIST_P384;
            }
            case 521: {
                return EllipticCurveType.NIST_P521;
            }
        }
        throw new IllegalArgumentException("unsupported curve for key size: " + pemKeyType.keySizeInBits);
    }

    public static final class Builder {
        private List<PemKey> pemKeys = new ArrayList<PemKey>();

        Builder() {
        }

        public KeysetReader build() {
            return new SignaturePemKeysetReader(this.pemKeys);
        }

        @CanIgnoreReturnValue
        public Builder addPem(String pem, PemKeyType keyType) {
            PemKey pemKey = new PemKey();
            pemKey.reader = new BufferedReader(new StringReader(pem));
            pemKey.type = keyType;
            this.pemKeys.add(pemKey);
            return this;
        }
    }

    private static final class PemKey {
        BufferedReader reader;
        PemKeyType type;

        private PemKey() {
        }
    }
}

