/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.os.Build;
import android.util.Log;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.RequiresApi;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.integration.android.AndroidKeystore;
import com.google.crypto.tink.integration.android.AndroidKeystoreAesGcm;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.util.Arrays;
import java.util.Locale;

public final class AndroidKeystoreKmsClient
implements KmsClient {
    private static final Object keystoreLock = new Object();
    private static final String TAG = AndroidKeystoreKmsClient.class.getSimpleName();
    private static final int MAX_WAIT_TIME_MILLISECONDS_BEFORE_RETRY = 40;
    public static final String PREFIX = "android-keystore://";
    private final String keyUri;

    @RequiresApi(value=23)
    public AndroidKeystoreKmsClient() throws GeneralSecurityException {
        this(new Builder());
    }

    @Deprecated
    @RequiresApi(value=23)
    public AndroidKeystoreKmsClient(String uri) {
        this(new Builder().setKeyUri(uri));
    }

    private AndroidKeystoreKmsClient(Builder builder) {
        this.keyUri = builder.keyUri;
    }

    @Override
    @RequiresApi(value=23)
    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    @Override
    @RequiresApi(value=23)
    public KmsClient withCredentials(String unused) throws GeneralSecurityException {
        return new AndroidKeystoreKmsClient();
    }

    @Override
    @RequiresApi(value=23)
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        return new AndroidKeystoreKmsClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        try {
            Object object = keystoreLock;
            synchronized (object) {
                AndroidKeystoreAesGcm aead = new AndroidKeystoreAesGcm(Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, uri));
                return AndroidKeystoreKmsClient.validateAead(aead);
            }
        }
        catch (IOException ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKey(String keyUri) throws GeneralSecurityException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        Object object = keystoreLock;
        synchronized (object) {
            AndroidKeystore.deleteKey(keyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasKey(String keyUri) throws GeneralSecurityException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        try {
            Object object = keystoreLock;
            synchronized (object) {
                return AndroidKeystore.hasKey(keyId);
            }
        }
        catch (NullPointerException ex1) {
            Log.w((String)TAG, (String)"Keystore is temporarily unavailable, wait, reinitialize Keystore and try again.");
            AndroidKeystoreKmsClient.sleepRandomAmount();
            Object object = keystoreLock;
            synchronized (object) {
                return AndroidKeystore.hasKey(keyId);
            }
        }
    }

    private static void sleepRandomAmount() {
        int waitTimeMillis = (int)(Math.random() * 40.0);
        try {
            Thread.sleep(waitTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=23)
    public static Aead getOrGenerateNewAeadKey(String keyUri) throws GeneralSecurityException, IOException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        Object object = keystoreLock;
        synchronized (object) {
            if (!AndroidKeystore.hasKey(keyId)) {
                AndroidKeystore.generateNewAes256GcmKey(keyId);
            }
            AndroidKeystoreAesGcm aead = new AndroidKeystoreAesGcm(keyId);
            return AndroidKeystoreKmsClient.validateAead(aead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=23)
    public static void generateNewAeadKey(String keyUri) throws GeneralSecurityException {
        Object object = keystoreLock;
        synchronized (object) {
            String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
            if (AndroidKeystore.hasKey(keyId)) {
                throw new IllegalArgumentException(String.format("cannot generate a new key %s because it already exists; please delete it with deleteKey() and try again", keyUri));
            }
            AndroidKeystore.generateNewAes256GcmKey(keyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=23)
    static boolean generateKeyIfNotExist(String keyUri) throws GeneralSecurityException {
        Object object = keystoreLock;
        synchronized (object) {
            String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
            if (!AndroidKeystore.hasKey(keyId)) {
                AndroidKeystore.generateNewAes256GcmKey(keyId);
                return true;
            }
            return false;
        }
    }

    @CanIgnoreReturnValue
    private static Aead validateAead(Aead aead) throws GeneralSecurityException {
        byte[] aad;
        byte[] ciphertext;
        byte[] decrypted;
        byte[] message = Random.randBytes(10);
        if (!Arrays.equals(message, decrypted = aead.decrypt(ciphertext = aead.encrypt(message, aad = new byte[0]), aad))) {
            throw new KeyStoreException("cannot use Android Keystore: encryption/decryption of non-empty message and empty aad returns an incorrect result");
        }
        return aead;
    }

    @ChecksSdkIntAtLeast(api=23)
    private static boolean isAtLeastM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static final class Builder {
        String keyUri = null;

        @RequiresApi(value=23)
        public Builder() {
            if (!AndroidKeystoreKmsClient.isAtLeastM()) {
                throw new IllegalStateException("need Android Keystore on Android M or newer");
            }
        }

        @CanIgnoreReturnValue
        @RequiresApi(value=23)
        public Builder setKeyUri(String val) {
            if (val == null || !val.toLowerCase(Locale.US).startsWith(AndroidKeystoreKmsClient.PREFIX)) {
                throw new IllegalArgumentException("val must start with android-keystore://");
            }
            this.keyUri = val;
            return this;
        }

        public AndroidKeystoreKmsClient build() {
            return new AndroidKeystoreKmsClient(this);
        }
    }
}

