/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.aead.internal.LegacyFullAead;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.MonitoringClient;
import com.google.crypto.tink.internal.MonitoringKeysetInfo;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.internal.PrimitiveWrapper;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;

public class AeadWrapper
implements PrimitiveWrapper<Aead, Aead> {
    private static final AeadWrapper WRAPPER = new AeadWrapper();
    private static final PrimitiveConstructor<LegacyProtoKey, Aead> LEGACY_FULL_AEAD_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(LegacyFullAead::create, LegacyProtoKey.class, Aead.class);

    AeadWrapper() {
    }

    @Override
    public Aead wrap(PrimitiveSet<Aead> pset) throws GeneralSecurityException {
        return new WrappedAead(pset);
    }

    @Override
    public Class<Aead> getPrimitiveClass() {
        return Aead.class;
    }

    @Override
    public Class<Aead> getInputPrimitiveClass() {
        return Aead.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(LEGACY_FULL_AEAD_PRIMITIVE_CONSTRUCTOR);
    }

    public static void registerToInternalPrimitiveRegistry(PrimitiveRegistry.Builder primitiveRegistryBuilder) throws GeneralSecurityException {
        primitiveRegistryBuilder.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedAead
    implements Aead {
        private final PrimitiveSet<Aead> pSet;
        private final MonitoringClient.Logger encLogger;
        private final MonitoringClient.Logger decLogger;

        private WrappedAead(PrimitiveSet<Aead> pSet) {
            this.pSet = pSet;
            if (pSet.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(pSet);
                this.encLogger = client.createLogger(keysetInfo, "aead", "encrypt");
                this.decLogger = client.createLogger(keysetInfo, "aead", "decrypt");
            } else {
                this.encLogger = MonitoringUtil.DO_NOTHING_LOGGER;
                this.decLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            try {
                byte[] result = this.pSet.getPrimary().getFullPrimitive().encrypt(plaintext, associatedData);
                this.encLogger.log(this.pSet.getPrimary().getKeyId(), plaintext.length);
                return result;
            }
            catch (GeneralSecurityException e) {
                this.encLogger.logFailure();
                throw e;
            }
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOf(ciphertext, 5);
                List<PrimitiveSet.Entry<Aead>> entries = this.pSet.getPrimitive(prefix);
                for (PrimitiveSet.Entry<Aead> entry : entries) {
                    try {
                        byte[] result = entry.getFullPrimitive().decrypt(ciphertext, associatedData);
                        this.decLogger.log(entry.getKeyId(), ciphertext.length);
                        return result;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                    }
                }
            }
            List<PrimitiveSet.Entry<Aead>> entries = this.pSet.getRawPrimitives();
            for (PrimitiveSet.Entry<Aead> entry : entries) {
                try {
                    byte[] result = entry.getFullPrimitive().decrypt(ciphertext, associatedData);
                    this.decLogger.log(entry.getKeyId(), ciphertext.length);
                    return result;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            this.decLogger.logFailure();
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

