/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.shaded.protobuf;

import java.util.logging.Logger;

public final class RuntimeVersion {
    public static final RuntimeDomain DOMAIN = RuntimeDomain.PUBLIC;
    public static final int MAJOR = 4;
    public static final int MINOR = 27;
    public static final int PATCH = 0;
    public static final String SUFFIX = "";
    private static final String VERSION_STRING = RuntimeVersion.versionString(4, 27, 0, "");
    private static final Logger logger = Logger.getLogger(RuntimeVersion.class.getName());

    public static void validateProtobufGencodeVersion(RuntimeDomain domain, int major, int minor, int patch, String suffix, String location) {
        if (RuntimeVersion.checkDisabled()) {
            return;
        }
        RuntimeVersion.validateProtobufGencodeVersionImpl(domain, major, minor, patch, suffix, location);
    }

    private static void validateProtobufGencodeVersionImpl(RuntimeDomain domain, int major, int minor, int patch, String suffix, String location) {
        if (RuntimeVersion.checkDisabled()) {
            return;
        }
        String gencodeVersionString = RuntimeVersion.versionString(major, minor, patch, suffix);
        if (major < 0 || minor < 0 || patch < 0) {
            throw new ProtobufRuntimeVersionException("Invalid gencode version: " + gencodeVersionString);
        }
        if (domain != DOMAIN) {
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime domains when loading %s: gencode %s, runtime %s. Cross-domain usage of Protobuf is not supported.", new Object[]{location, domain, DOMAIN}));
        }
        if (major != 4) {
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime major versions when loading %s: gencode %s, runtime %s. Same major version is required.", location, gencodeVersionString, VERSION_STRING));
        }
        if (27 < minor || 27 == minor && 0 < patch) {
            throw new ProtobufRuntimeVersionException(String.format("Detected incompatible Protobuf Gencode/Runtime versions when loading %s: gencode %s, runtime %s. Runtime version cannot be older than the linked gencode version.", location, gencodeVersionString, VERSION_STRING));
        }
        if (!suffix.equals(SUFFIX)) {
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime version suffixes when loading %s: gencode %s, runtime %s. Version suffixes must be the same.", location, gencodeVersionString, VERSION_STRING));
        }
    }

    private static String versionString(int major, int minor, int patch, String suffix) {
        return String.format("%d.%d.%d%s", major, minor, patch, suffix);
    }

    private static boolean checkDisabled() {
        String disableFlag = System.getenv("TEMORARILY_DISABLE_PROTOBUF_VERSION_CHECK");
        return disableFlag != null && disableFlag.equals("true");
    }

    private RuntimeVersion() {
    }

    public static final class ProtobufRuntimeVersionException
    extends RuntimeException {
        public ProtobufRuntimeVersionException(String message) {
            super(message);
        }
    }

    public static enum RuntimeDomain {
        GOOGLE_INTERNAL,
        PUBLIC;

    }
}

