/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.aead.AesEaxKey;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesEaxJce
implements Aead {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS;
    private static final ThreadLocal<Cipher> localEcbCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return EngineFactory.CIPHER.getInstance("AES/ECB/NOPADDING");
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalStateException(ex);
            }
        }
    };
    private static final ThreadLocal<Cipher> localCtrCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return EngineFactory.CIPHER.getInstance("AES/CTR/NOPADDING");
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalStateException(ex);
            }
        }
    };
    static final int BLOCK_SIZE_IN_BYTES = 16;
    static final int TAG_SIZE_IN_BYTES = 16;
    private final byte[] b;
    private final byte[] p;
    private final byte[] outputPrefix;
    private final SecretKeySpec keySpec;
    private final int ivSizeInBytes;

    @AccessesPartialKey
    public static Aead create(AesEaxKey key) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        if (key.getParameters().getTagSizeBytes() != 16) {
            throw new GeneralSecurityException("AesEaxJce only supports 16 byte tag size, not " + key.getParameters().getTagSizeBytes());
        }
        return new AesEaxJce(key.getKeyBytes().toByteArray(InsecureSecretKeyAccess.get()), key.getParameters().getIvSizeBytes(), key.getOutputPrefix().toByteArray());
    }

    private AesEaxJce(byte[] key, int ivSizeInBytes, byte[] outputPrefix) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        if (ivSizeInBytes != 12 && ivSizeInBytes != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.ivSizeInBytes = ivSizeInBytes;
        Validators.validateAesKeySize(key.length);
        this.keySpec = new SecretKeySpec(key, "AES");
        Cipher ecb = localEcbCipher.get();
        ecb.init(1, this.keySpec);
        byte[] block = ecb.doFinal(new byte[16]);
        this.b = AesEaxJce.multiplyByX(block);
        this.p = AesEaxJce.multiplyByX(this.b);
        this.outputPrefix = outputPrefix;
    }

    public AesEaxJce(byte[] key, int ivSizeInBytes) throws GeneralSecurityException {
        this(key, ivSizeInBytes, new byte[0]);
    }

    private static byte[] xor(byte[] x, byte[] y) {
        assert (x.length == y.length);
        int len = x.length;
        byte[] res = new byte[len];
        for (int i = 0; i < len; ++i) {
            res[i] = (byte)(x[i] ^ y[i]);
        }
        return res;
    }

    private static byte[] multiplyByX(byte[] block) {
        byte[] res = new byte[16];
        for (int i = 0; i < 15; ++i) {
            res[i] = (byte)((block[i] << 1 ^ (block[i + 1] & 0xFF) >>> 7) & 0xFF);
        }
        res[15] = (byte)(block[15] << 1 ^ block[0] >> 7 & 0x87);
        return res;
    }

    private byte[] pad(byte[] data) {
        if (data.length == 16) {
            return AesEaxJce.xor(data, this.b);
        }
        byte[] res = Arrays.copyOf(this.p, 16);
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            res[n] = (byte)(res[n] ^ data[i]);
        }
        res[data.length] = (byte)(res[data.length] ^ 0x80);
        return res;
    }

    private byte[] omac(Cipher ecb, int tag, byte[] data, int offset, int length) throws IllegalBlockSizeException, BadPaddingException {
        assert (length >= 0);
        assert (0 <= tag && tag <= 3);
        byte[] block = new byte[16];
        block[15] = (byte)tag;
        if (length == 0) {
            return ecb.doFinal(AesEaxJce.xor(block, this.b));
        }
        block = ecb.doFinal(block);
        int position = 0;
        while (length - position > 16) {
            for (int i = 0; i < 16; ++i) {
                int n = i;
                block[n] = (byte)(block[n] ^ data[offset + position + i]);
            }
            block = ecb.doFinal(block);
            position += 16;
        }
        byte[] padded = this.pad(Arrays.copyOfRange(data, offset + position, offset + length));
        block = AesEaxJce.xor(block, padded);
        return ecb.doFinal(block);
    }

    private byte[] rawEncrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        if (plaintext.length > Integer.MAX_VALUE - this.ivSizeInBytes - 16) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] ciphertext = new byte[this.ivSizeInBytes + plaintext.length + 16];
        byte[] iv = Random.randBytes(this.ivSizeInBytes);
        System.arraycopy(iv, 0, ciphertext, 0, this.ivSizeInBytes);
        Cipher ecb = localEcbCipher.get();
        ecb.init(1, this.keySpec);
        byte[] n = this.omac(ecb, 0, iv, 0, iv.length);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        byte[] h = this.omac(ecb, 1, aad, 0, aad.length);
        Cipher ctr = localCtrCipher.get();
        ctr.init(1, (Key)this.keySpec, new IvParameterSpec(n));
        ctr.doFinal(plaintext, 0, plaintext.length, ciphertext, this.ivSizeInBytes);
        byte[] t = this.omac(ecb, 2, ciphertext, this.ivSizeInBytes, plaintext.length);
        int offset = plaintext.length + this.ivSizeInBytes;
        for (int i = 0; i < 16; ++i) {
            ciphertext[offset + i] = (byte)(h[i] ^ n[i] ^ t[i]);
        }
        return ciphertext;
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        byte[] ciphertext = this.rawEncrypt(plaintext, associatedData);
        if (this.outputPrefix.length == 0) {
            return ciphertext;
        }
        return Bytes.concat(this.outputPrefix, ciphertext);
    }

    private byte[] rawDecrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        int plaintextLength = ciphertext.length - this.ivSizeInBytes - 16;
        if (plaintextLength < 0) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        Cipher ecb = localEcbCipher.get();
        ecb.init(1, this.keySpec);
        byte[] n = this.omac(ecb, 0, ciphertext, 0, this.ivSizeInBytes);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        byte[] h = this.omac(ecb, 1, aad, 0, aad.length);
        byte[] t = this.omac(ecb, 2, ciphertext, this.ivSizeInBytes, plaintextLength);
        int res = 0;
        int offset = ciphertext.length - 16;
        for (int i = 0; i < 16; ++i) {
            res = (byte)(res | ciphertext[offset + i] ^ h[i] ^ n[i] ^ t[i]);
        }
        if (res != 0) {
            throw new AEADBadTagException("tag mismatch");
        }
        Cipher ctr = localCtrCipher.get();
        ctr.init(1, (Key)this.keySpec, new IvParameterSpec(n));
        return ctr.doFinal(ciphertext, this.ivSizeInBytes, plaintextLength);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        if (this.outputPrefix.length == 0) {
            return this.rawDecrypt(ciphertext, associatedData);
        }
        if (!Util.isPrefix(this.outputPrefix, ciphertext)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        byte[] copiedCiphertext = Arrays.copyOfRange(ciphertext, this.outputPrefix.length, ciphertext.length);
        return this.rawDecrypt(copiedCiphertext, associatedData);
    }
}

