/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.Mac;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.mac.internal.LegacyFullMac;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;

public class MacWrapper
implements PrimitiveWrapper<Mac, Mac> {
    private static final MacWrapper WRAPPER = new MacWrapper();
    private static final PrimitiveConstructor<LegacyProtoKey, Mac> LEGACY_FULL_MAC_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(LegacyFullMac::create, LegacyProtoKey.class, Mac.class);

    MacWrapper() {
    }

    @Override
    public Mac wrap(PrimitiveSet<Mac> primitives) throws GeneralSecurityException {
        return new WrappedMac(primitives);
    }

    @Override
    public Class<Mac> getPrimitiveClass() {
        return Mac.class;
    }

    @Override
    public Class<Mac> getInputPrimitiveClass() {
        return Mac.class;
    }

    static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(LEGACY_FULL_MAC_PRIMITIVE_CONSTRUCTOR);
    }

    public static void registerToInternalPrimitiveRegistry(PrimitiveRegistry.Builder primitiveRegistryBuilder) throws GeneralSecurityException {
        primitiveRegistryBuilder.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedMac
    implements Mac {
        private final PrimitiveSet<Mac> primitives;
        private final MonitoringClient.Logger computeLogger;
        private final MonitoringClient.Logger verifyLogger;

        private WrappedMac(PrimitiveSet<Mac> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.computeLogger = client.createLogger(keysetInfo, "mac", "compute");
                this.verifyLogger = client.createLogger(keysetInfo, "mac", "verify");
            } else {
                this.computeLogger = MonitoringUtil.DO_NOTHING_LOGGER;
                this.verifyLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] computeMac(byte[] data) throws GeneralSecurityException {
            try {
                byte[] output = this.primitives.getPrimary().getFullPrimitive().computeMac(data);
                this.computeLogger.log(this.primitives.getPrimary().getKeyId(), data.length);
                return output;
            }
            catch (GeneralSecurityException e) {
                this.computeLogger.logFailure();
                throw e;
            }
        }

        @Override
        public void verifyMac(byte[] mac, byte[] data) throws GeneralSecurityException {
            if (mac.length <= 5) {
                this.verifyLogger.logFailure();
                throw new GeneralSecurityException("tag too short");
            }
            byte[] prefix = Arrays.copyOf(mac, 5);
            List<PrimitiveSet.Entry<Mac>> entries = this.primitives.getPrimitive(prefix);
            for (PrimitiveSet.Entry<Mac> entry : entries) {
                try {
                    entry.getFullPrimitive().verifyMac(mac, data);
                    this.verifyLogger.log(entry.getKeyId(), data.length);
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<Mac> entry : entries) {
                try {
                    entry.getFullPrimitive().verifyMac(mac, data);
                    this.verifyLogger.log(entry.getKeyId(), data.length);
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            this.verifyLogger.logFailure();
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

