/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.mac.ChunkedMac;
import com.google.crypto.tink.mac.ChunkedMacComputation;
import com.google.crypto.tink.mac.ChunkedMacVerification;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChunkedMacWrapper
implements PrimitiveWrapper<ChunkedMac, ChunkedMac> {
    private static final ChunkedMacWrapper WRAPPER = new ChunkedMacWrapper();

    private ChunkedMacWrapper() {
    }

    @Override
    public ChunkedMac wrap(PrimitiveSet<ChunkedMac> primitives) throws GeneralSecurityException {
        if (primitives == null) {
            throw new GeneralSecurityException("primitive set must be non-null");
        }
        if (primitives.getPrimary() == null) {
            throw new GeneralSecurityException("no primary in primitive set");
        }
        for (List<PrimitiveSet.Entry<ChunkedMac>> list : primitives.getAll()) {
            for (PrimitiveSet.Entry<ChunkedMac> entry : list) {
                ChunkedMac chunkedMac = entry.getFullPrimitive();
            }
        }
        return new WrappedChunkedMac(primitives);
    }

    @Override
    public Class<ChunkedMac> getPrimitiveClass() {
        return ChunkedMac.class;
    }

    @Override
    public Class<ChunkedMac> getInputPrimitiveClass() {
        return ChunkedMac.class;
    }

    static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
    }

    public static void registerToInternalPrimitiveRegistry(PrimitiveRegistry.Builder primitiveRegistryBuilder) throws GeneralSecurityException {
        primitiveRegistryBuilder.registerPrimitiveWrapper(WRAPPER);
    }

    @Immutable
    private static class WrappedChunkedMac
    implements ChunkedMac {
        private final PrimitiveSet<ChunkedMac> primitives;

        private WrappedChunkedMac(PrimitiveSet<ChunkedMac> primitives) {
            this.primitives = primitives;
        }

        @Override
        public ChunkedMacComputation createComputation() throws GeneralSecurityException {
            return this.getChunkedMac(this.primitives.getPrimary()).createComputation();
        }

        private ChunkedMac getChunkedMac(PrimitiveSet.Entry<ChunkedMac> entry) {
            return entry.getFullPrimitive();
        }

        @Override
        public ChunkedMacVerification createVerification(byte[] tag) throws GeneralSecurityException {
            byte[] prefix = Arrays.copyOf(tag, 5);
            ArrayList<ChunkedMacVerification> verifications = new ArrayList<ChunkedMacVerification>();
            for (PrimitiveSet.Entry<ChunkedMac> primitive : this.primitives.getPrimitive(prefix)) {
                verifications.add(this.getChunkedMac(primitive).createVerification(tag));
            }
            for (PrimitiveSet.Entry<ChunkedMac> primitive : this.primitives.getRawPrimitives()) {
                verifications.add(this.getChunkedMac(primitive).createVerification(tag));
            }
            return new WrappedChunkedMacVerification(verifications);
        }
    }

    private static class WrappedChunkedMacVerification
    implements ChunkedMacVerification {
        private final List<ChunkedMacVerification> verifications;

        private WrappedChunkedMacVerification(List<ChunkedMacVerification> verificationEntries) {
            this.verifications = verificationEntries;
        }

        @Override
        public void update(ByteBuffer data) throws GeneralSecurityException {
            ByteBuffer clonedData = data.duplicate();
            clonedData.mark();
            for (ChunkedMacVerification entry : this.verifications) {
                clonedData.reset();
                entry.update(clonedData);
            }
            data.position(data.limit());
        }

        @Override
        public void verifyMac() throws GeneralSecurityException {
            GeneralSecurityException errorSink = new GeneralSecurityException("MAC verification failed for all suitable keys in keyset");
            for (ChunkedMacVerification entry : this.verifications) {
                try {
                    entry.verifyMac();
                    return;
                }
                catch (GeneralSecurityException e) {
                    errorSink.addSuppressed(e);
                }
            }
            throw errorSink;
        }
    }
}

