/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.daead;

import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.daead.internal.LegacyFullDeterministicAead;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;

public class DeterministicAeadWrapper
implements PrimitiveWrapper<DeterministicAead, DeterministicAead> {
    private static final DeterministicAeadWrapper WRAPPER = new DeterministicAeadWrapper();
    private static final PrimitiveConstructor<LegacyProtoKey, DeterministicAead> LEGACY_FULL_DAEAD_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(LegacyFullDeterministicAead::create, LegacyProtoKey.class, DeterministicAead.class);

    DeterministicAeadWrapper() {
    }

    @Override
    public DeterministicAead wrap(PrimitiveSet<DeterministicAead> primitives) {
        return new WrappedDeterministicAead(primitives);
    }

    @Override
    public Class<DeterministicAead> getPrimitiveClass() {
        return DeterministicAead.class;
    }

    @Override
    public Class<DeterministicAead> getInputPrimitiveClass() {
        return DeterministicAead.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(LEGACY_FULL_DAEAD_PRIMITIVE_CONSTRUCTOR);
    }

    public static void registerToInternalPrimitiveRegistry(PrimitiveRegistry.Builder primitiveRegistryBuilder) throws GeneralSecurityException {
        primitiveRegistryBuilder.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedDeterministicAead
    implements DeterministicAead {
        private final PrimitiveSet<DeterministicAead> primitives;
        private final MonitoringClient.Logger encLogger;
        private final MonitoringClient.Logger decLogger;

        public WrappedDeterministicAead(PrimitiveSet<DeterministicAead> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.encLogger = client.createLogger(keysetInfo, "daead", "encrypt");
                this.decLogger = client.createLogger(keysetInfo, "daead", "decrypt");
            } else {
                this.encLogger = MonitoringUtil.DO_NOTHING_LOGGER;
                this.decLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] encryptDeterministically(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            try {
                byte[] output = this.primitives.getPrimary().getFullPrimitive().encryptDeterministically(plaintext, associatedData);
                this.encLogger.log(this.primitives.getPrimary().getKeyId(), plaintext.length);
                return output;
            }
            catch (GeneralSecurityException e) {
                this.encLogger.logFailure();
                throw e;
            }
        }

        @Override
        public byte[] decryptDeterministically(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOf(ciphertext, 5);
                List<PrimitiveSet.Entry<DeterministicAead>> entries = this.primitives.getPrimitive(prefix);
                for (PrimitiveSet.Entry<DeterministicAead> entry : entries) {
                    try {
                        byte[] output = entry.getFullPrimitive().decryptDeterministically(ciphertext, associatedData);
                        this.decLogger.log(entry.getKeyId(), ciphertext.length);
                        return output;
                    }
                    catch (GeneralSecurityException e) {
                    }
                }
            }
            List<PrimitiveSet.Entry<DeterministicAead>> entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<DeterministicAead> entry : entries) {
                try {
                    byte[] output = entry.getFullPrimitive().decryptDeterministically(ciphertext, associatedData);
                    this.decLogger.log(entry.getKeyId(), ciphertext.length);
                    return output;
                }
                catch (GeneralSecurityException e) {
                }
            }
            this.decLogger.logFailure();
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

