/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead.internal;

import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class InsecureNonceAesGcmJce {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    public static final int IV_SIZE_IN_BYTES = 12;
    public static final int TAG_SIZE_IN_BYTES = 16;
    private static final ThreadLocal<Cipher> localCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return EngineFactory.CIPHER.getInstance("AES/GCM/NoPadding");
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalStateException(ex);
            }
        }
    };
    private final SecretKey keySpec;

    public static Cipher getThreadLocalCipher() {
        return localCipher.get();
    }

    public InsecureNonceAesGcmJce(byte[] key) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use AES-GCM in FIPS-mode, as BoringCrypto module is not available.");
        }
        Validators.validateAesKeySize(key.length);
        this.keySpec = new SecretKeySpec(key, "AES");
    }

    public byte[] encrypt(byte[] iv, byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        if (iv.length != 12) {
            throw new GeneralSecurityException("iv is wrong size");
        }
        if (plaintext.length > 2147483619) {
            throw new GeneralSecurityException("plaintext too long");
        }
        AlgorithmParameterSpec params = InsecureNonceAesGcmJce.getParams(iv);
        localCipher.get().init(1, (Key)this.keySpec, params);
        if (associatedData != null && associatedData.length != 0) {
            localCipher.get().updateAAD(associatedData);
        }
        return localCipher.get().doFinal(plaintext);
    }

    public byte[] decrypt(byte[] iv, byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        if (iv.length != 12) {
            throw new GeneralSecurityException("iv is wrong size");
        }
        if (ciphertext.length < 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        AlgorithmParameterSpec params = InsecureNonceAesGcmJce.getParams(iv);
        localCipher.get().init(2, (Key)this.keySpec, params);
        if (associatedData != null && associatedData.length != 0) {
            localCipher.get().updateAAD(associatedData);
        }
        return localCipher.get().doFinal(ciphertext);
    }

    public static AlgorithmParameterSpec getParams(byte[] iv) throws GeneralSecurityException {
        return InsecureNonceAesGcmJce.getParams(iv, 0, iv.length);
    }

    private static AlgorithmParameterSpec getParams(byte[] buf, int offset, int len) throws GeneralSecurityException {
        Integer apiLevel = Util.getAndroidApiLevel();
        if (apiLevel != null && apiLevel <= 19) {
            return new IvParameterSpec(buf, offset, len);
        }
        return new GCMParameterSpec(128, buf, offset, len);
    }
}

