/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.prf;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.MutableParametersRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.internal.TinkBugException;
import com.google.crypto.tink.prf.AesCmacPrfKey;
import com.google.crypto.tink.prf.AesCmacPrfParameters;
import com.google.crypto.tink.prf.AesCmacPrfProtoSerialization;
import com.google.crypto.tink.prf.PredefinedPrfParameters;
import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.proto.AesCmacPrfKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.PrfAesCmac;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class AesCmacPrfKeyManager
extends KeyTypeManager<com.google.crypto.tink.proto.AesCmacPrfKey> {
    private static final int VERSION = 0;
    private static final int KEY_SIZE_IN_BYTES = 32;
    private static final PrimitiveConstructor<AesCmacPrfKey, Prf> PRF_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(PrfAesCmac::create, AesCmacPrfKey.class, Prf.class);

    AesCmacPrfKeyManager() {
        super(com.google.crypto.tink.proto.AesCmacPrfKey.class, new PrimitiveFactory<Prf, com.google.crypto.tink.proto.AesCmacPrfKey>(Prf.class){

            @Override
            public Prf getPrimitive(com.google.crypto.tink.proto.AesCmacPrfKey key) throws GeneralSecurityException {
                return new PrfAesCmac(key.getKeyValue().toByteArray());
            }
        });
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS;
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.AesCmacPrfKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(com.google.crypto.tink.proto.AesCmacPrfKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        AesCmacPrfKeyManager.validateSize(key.getKeyValue().size());
    }

    @Override
    public com.google.crypto.tink.proto.AesCmacPrfKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return com.google.crypto.tink.proto.AesCmacPrfKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    private static void validateSize(int size) throws GeneralSecurityException {
        if (size != 32) {
            throw new GeneralSecurityException("AesCmacPrfKey size wrong, must be 32 bytes");
        }
    }

    @Override
    public KeyTypeManager.KeyFactory<AesCmacPrfKeyFormat, com.google.crypto.tink.proto.AesCmacPrfKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<AesCmacPrfKeyFormat, com.google.crypto.tink.proto.AesCmacPrfKey>(AesCmacPrfKeyFormat.class){

            @Override
            public void validateKeyFormat(AesCmacPrfKeyFormat format) throws GeneralSecurityException {
                AesCmacPrfKeyManager.validateSize(format.getKeySize());
            }

            @Override
            public AesCmacPrfKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return AesCmacPrfKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public com.google.crypto.tink.proto.AesCmacPrfKey createKey(AesCmacPrfKeyFormat format) {
                return (com.google.crypto.tink.proto.AesCmacPrfKey)com.google.crypto.tink.proto.AesCmacPrfKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom(Random.randBytes(format.getKeySize()))).build();
            }
        };
    }

    private static Map<String, Parameters> namedParameters() throws GeneralSecurityException {
        HashMap<String, AesCmacPrfParameters> result = new HashMap<String, AesCmacPrfParameters>();
        result.put("AES256_CMAC_PRF", PredefinedPrfParameters.AES_CMAC_PRF);
        result.put("AES_CMAC_PRF", PredefinedPrfParameters.AES_CMAC_PRF);
        return Collections.unmodifiableMap(result);
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new AesCmacPrfKeyManager(), newKeyAllowed);
        AesCmacPrfProtoSerialization.register();
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(PRF_PRIMITIVE_CONSTRUCTOR);
        MutableParametersRegistry.globalInstance().putAll(AesCmacPrfKeyManager.namedParameters());
    }

    public static final KeyTemplate aes256CmacTemplate() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(AesCmacPrfParameters.create(32)));
    }
}

