/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.jwt.JsonUtil;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtPublicKeyVerifyInternal;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.crypto.tink.proto.JwtRsaSsaPssAlgorithm;
import com.google.crypto.tink.proto.JwtRsaSsaPssPublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.RsaSsaPssVerifyJce;
import com.google.crypto.tink.subtle.Validators;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Optional;

class JwtRsaSsaPssVerifyKeyManager
extends KeyTypeManager<JwtRsaSsaPssPublicKey> {
    static final Enums.HashType hashForPssAlgorithm(JwtRsaSsaPssAlgorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case PS256: {
                return Enums.HashType.SHA256;
            }
            case PS384: {
                return Enums.HashType.SHA384;
            }
            case PS512: {
                return Enums.HashType.SHA512;
            }
        }
        throw new GeneralSecurityException("unknown algorithm " + algorithm.name());
    }

    static final int saltLengthForPssAlgorithm(JwtRsaSsaPssAlgorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case PS256: {
                return 32;
            }
            case PS384: {
                return 48;
            }
            case PS512: {
                return 64;
            }
        }
        throw new GeneralSecurityException("unknown algorithm " + algorithm.name());
    }

    private static final RSAPublicKey createPublicKey(JwtRsaSsaPssPublicKey keyProto) throws GeneralSecurityException {
        KeyFactory kf = EngineFactory.KEY_FACTORY.getInstance("RSA");
        BigInteger modulus = new BigInteger(1, keyProto.getN().toByteArray());
        BigInteger exponent = new BigInteger(1, keyProto.getE().toByteArray());
        return (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(modulus, exponent));
    }

    public JwtRsaSsaPssVerifyKeyManager() {
        super(JwtRsaSsaPssPublicKey.class, new PrimitiveFactory<JwtPublicKeyVerifyInternal, JwtRsaSsaPssPublicKey>(JwtPublicKeyVerifyInternal.class){

            @Override
            public JwtPublicKeyVerifyInternal getPrimitive(JwtRsaSsaPssPublicKey keyProto) throws GeneralSecurityException {
                RSAPublicKey publickey = JwtRsaSsaPssVerifyKeyManager.createPublicKey(keyProto);
                Enums.HashType hash = JwtRsaSsaPssVerifyKeyManager.hashForPssAlgorithm(keyProto.getAlgorithm());
                int saltLength = JwtRsaSsaPssVerifyKeyManager.saltLengthForPssAlgorithm(keyProto.getAlgorithm());
                final RsaSsaPssVerifyJce verifier = new RsaSsaPssVerifyJce(publickey, hash, hash, saltLength);
                final String algorithmName = keyProto.getAlgorithm().name();
                final Optional customKidFromRsaSsaPssPublicKey = keyProto.hasCustomKid() ? Optional.of(keyProto.getCustomKid().getValue()) : Optional.empty();
                return new JwtPublicKeyVerifyInternal(){

                    @Override
                    public VerifiedJwt verifyAndDecodeWithKid(String compact, JwtValidator validator, Optional<String> kid) throws GeneralSecurityException {
                        JwtFormat.Parts parts = JwtFormat.splitSignedCompact(compact);
                        verifier.verify(parts.signatureOrMac, parts.unsignedCompact.getBytes(StandardCharsets.US_ASCII));
                        JsonObject parsedHeader = JsonUtil.parseJson(parts.header);
                        JwtFormat.validateHeader(algorithmName, kid, customKidFromRsaSsaPssPublicKey, parsedHeader);
                        RawJwt token = RawJwt.fromJsonPayload(JwtFormat.getTypeHeader(parsedHeader), parts.payload);
                        return validator.validate(token);
                    }
                };
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.JwtRsaSsaPssPublicKey";
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
    }

    @Override
    public JwtRsaSsaPssPublicKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return JwtRsaSsaPssPublicKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void validateKey(JwtRsaSsaPssPublicKey pubKey) throws GeneralSecurityException {
        Validators.validateVersion(pubKey.getVersion(), this.getVersion());
        Validators.validateRsaModulusSize(new BigInteger(1, pubKey.getN().toByteArray()).bitLength());
        Validators.validateRsaPublicExponent(new BigInteger(1, pubKey.getE().toByteArray()));
    }
}

